unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, Variants, DateUtils;

type
  TForm1 = class(TForm)
    Edit_HH: TEdit;
    Edit_SS: TEdit;
    Edit_DD: TEdit;
    Edit_MM: TEdit;
    Edit_YY: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    ffnen1: TMenuItem;
    N1: TMenuItem;
    Ende1: TMenuItem;
    Ende2: TMenuItem;
    OpenDialog1: TOpenDialog;
    Label5: TLabel;
    Edit_NN: TEdit;
    N2: TMenuItem;
    ber1: TMenuItem;
    Extras1: TMenuItem;
    DatenMerken: TMenuItem;
    DatenSchreiben: TMenuItem;
    N3: TMenuItem;
    DatenLoeschen: TMenuItem;
    OpenDialog2: TOpenDialog;
    Optionen1: TMenuItem;
    Schreibschutz: TMenuItem;
    Memo1: TMemo;
    DatumSetzen: TMenuItem;
    OpenDialog3: TOpenDialog;
    ZeitErhoehen: TMenuItem;
    procedure ffnen1Click(Sender: TObject);
    procedure Ende2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit_HHChange(Sender: TObject);
    procedure Edit_NNChange(Sender: TObject);
    procedure Edit_SSChange(Sender: TObject);
    procedure Edit_DDChange(Sender: TObject);
    procedure Edit_MMChange(Sender: TObject);
    procedure Edit_YYChange(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure ber1Click(Sender: TObject);
    procedure DatenMerkenClick(Sender: TObject);
    procedure DatenSchreibenClick(Sender: TObject);
    procedure DatenLoeschenClick(Sender: TObject);
    procedure SchreibschutzClick(Sender: TObject);
    procedure DatumSetzenClick(Sender: TObject);
    procedure ZeitErhoehenClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  FileHandle, DateiOffen, Zahl: Integer;
  Datum, Attrs: Integer;
  hh,nn,ss,ms,dd,mm,yy:Word;
  hhS,nnS,ssS,msS,ddS,mmS,yyS:String;
  Daten: Variant;
implementation

uses Unit2, Unit3;

{$R *.DFM}


procedure TForm1.ffnen1Click(Sender: TObject);
var xaxa:string;
var FileTime:TDateTime;
begin
  if OpenDialog1.Execute then begin
    FileHandle:=FileOpen(OpenDialog1.FileName, fmOpenRead);
    if FileHandle=-1 then begin
      ShowMessage('Es trat ein unerwarteter Fehler beim ffnen der Datei auf.'
        +' Mglicherweise wird die Datei bereits von einem anderen Programm'
        +' verwendet oder ausgefhrt. Schlieen Sie die Datei oder das Programm'
        +' und versuchen Sie es erneut.');
    end else begin
      Datum:=FileGetDate(FileHandle);
      FileTime:=FileDateToDateTime(Datum);
      DateiOffen:=1;
      FileClose(FileHandle);
      Form1.Label5.Caption := FormatDateTime('dd.mm.yyyy hh:nn:ss', FileTime);
      DecodeDate(FileTime,yy,mm,dd);
      DecodeTime(FileTime,hh,nn,ss,ms);
      Str(hh, hhS);
      Str(nn, nnS);
      Str(ss, ssS);
      Str(dd, ddS);
      Str(mm, mmS);
      Str(yy, yyS);
      Form1.Edit_HH.Text := hhS;
      Form1.Edit_NN.Text := nnS;
      Form1.Edit_SS.Text := ssS;
      Form1.Edit_DD.Text := ddS;
      Form1.Edit_MM.Text := mmS;
      Form1.Edit_YY.Text := yyS;
      Form1.Memo1.Lines[1] := OpenDialog1.FileName;
    end;
  end;
end;

procedure TForm1.Ende2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
var jetzt: TDateTime;
begin
  Form1.Label5.Caption:='';
  DateiOffen:=0;
  Daten:=VarArrayCreate([0, 1], varInteger);
  DatenMerken.Enabled := true;
  DatenSchreiben.enabled := false;
  DatenLoeschen.Enabled := false;

  jetzt := Now;
  DecodeDate(jetzt,yy,mm,dd);
  DecodeTime(jetzt,hh,nn,ss,ms);
  Str(hh, hhS);
  Str(nn, nnS);
  Str(ss, ssS);
  Str(dd, ddS);
  Str(mm, mmS);
  Str(yy, yyS);
  Form1.Edit_HH.Text := hhS;
  Form1.Edit_NN.Text := nnS;
  Form1.Edit_SS.Text := ssS;
  Form1.Edit_DD.Text := ddS;
  Form1.Edit_MM.Text := mmS;
  Form1.Edit_YY.Text := yyS;
end;



procedure NumStri(var Gabe: String);
var Code:Integer;
begin
  VAL(Gabe, Zahl, Code);
  STR(Zahl, Gabe);
  IF Zahl=0 then Gabe:=''
end;

function Stri(Zahl: Integer): String;
var Zei: string;
begin
  Str(Zahl, Zei);
  Stri:=Zei;
end;

procedure TForm1.Edit_HHChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_HH.Text;
  NumStri(Gab);
  Form1.Edit_HH.Text:=Gab;
  If (Zahl<0) or (Zahl>23) then Form1.Edit_HH.Text:='0';
end;


procedure TForm1.Edit_NNChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_NN.Text;
  NumStri(Gab);
  Form1.Edit_NN.Text:=Gab;
  IF (Zahl<0) or (Zahl>59) then Form1.Edit_NN.Text:='0';
end;

procedure TForm1.Edit_SSChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_SS.Text;
  NumStri(Gab);
  Form1.Edit_SS.Text:=Gab;
  IF (Zahl<0) or (Zahl>59) then Form1.Edit_SS.Text:='0';
end;

procedure TForm1.Edit_DDChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_DD.Text;
  NumStri(Gab);
  Form1.Edit_DD.Text:=Gab;
  {Hier fehlt noch eine Routine zum berprfen des Monatstags}
  IF (Zahl<1) or (Zahl>31) then Form1.Edit_DD.Text:='1';
end;

procedure TForm1.Edit_MMChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_MM.Text;
  NumStri(Gab);
  Form1.Edit_MM.Text:=Gab;
  IF (Zahl<1) or (Zahl>12) then Form1.Edit_MM.Text:='1';
end;

procedure TForm1.Edit_YYChange(Sender: TObject);
var Gab:String;
begin
  Gab:=Form1.Edit_YY.Text;
  NumStri(Gab);
  Form1.Edit_YY.Text:=Gab;
  IF (Zahl<1) or (Zahl>9999) then Form1.Edit_YY.Text:='1';
end;

procedure TForm1.N1Click(Sender: TObject);
var FileTime:TDateTime;
    enc, err, code:integer;
    dat1,dat2:TDateTime;
    dat3:Extended;

begin
  Attrs := FileGetAttr(OpenDialog1.FileName);
  if not (Attrs and faReadOnly = 0) then begin
    IF Schreibschutz.checked=false then begin
      err:=FileSetAttr(OpenDialog1.FileName, Attrs - faReadOnly);
      IF not err=0 then ShowMessage('Der Schreibschutz der Datei kann nicht'
                          +' umgangen werden. Prfen Sie, ob der Datentrger'
                          +' schreibgeschtzt ist.');
    end else
      ShowMessage('Die Datei ist schreibgeschtzt. Deaktivieren Sie'
                   +' im Men "Optionen" den Punkt "Schreibgeschtzte'
                   +' Dateien nicht bearbeiten" und versuchen Sie es erneut!');

  end;
  if FileGetAttr(OpenDialog1.FileName) and faReadOnly=0 then begin
    FileHandle:=FileOpen(OpenDialog1.FileName, fmOpenReadWrite);
    If (FileHandle=-1) then begin
      ShowMessage('Die Datei kann nicht gespeichert werden. Prfen Sie, ob der '
        +' Datentrger schreibgeschtzt ist (z.B. CD-Rom?) !');
    end else begin
      Val(Form1.Edit_HH.Text, hh, code);
      Val(Form1.Edit_NN.Text, nn, code);
      Val(Form1.Edit_SS.Text, ss, code);
      Val(Form1.Edit_DD.Text, dd, code);
      Val(Form1.Edit_MM.Text, mm, code);
      Val(Form1.Edit_YY.Text, yy, code);
      FileTime:=EncodeDate(yy,mm,dd) + EncodeTime(hh,nn,ss,ms);
      Datum:=DateTimeToFileDate(FileTime);
      enc:=FileSetDate(FileHandle, Datum);

      Datum:=FileGetDate(FileHandle);
      FileTime:=FileDateToDateTime(Datum);
      FileClose(FileHandle);
      Form1.Label5.Caption := FormatDateTime('dd.mm.yyyy hh:nn:ss', FileTime);
      if (Attrs and faReadOnly <> 0) and (Schreibschutz.checked=false) then begin
          FileSetAttr(OpenDialog1.FileName, Attrs);
      end;
    end;
  end;
end;


procedure TForm1.ber1Click(Sender: TObject);
begin
  form2.visible:=true;
end;

procedure TForm1.DatenMerkenClick(Sender: TObject);
var xaxa:string;
    zaehler2:integer;
begin
  if OpenDialog2.Execute then begin
    VarArrayRedim(Daten, OpenDialog2.Files.Count-1);
    For zaehler2:=0 to OpenDialog2.Files.Count-1 do begin
      FileHandle:=FileOpen(OpenDialog2.Files[zaehler2], fmOpenRead);
      Daten[zaehler2]:=FileGetDate(FileHandle);
      FileClose(FileHandle);
    end;
    DatenMerken.Enabled := false;
    DatenSchreiben.enabled := true;
    DatenLoeschen.Enabled := true;
  end;
end;

procedure TForm1.DatenSchreibenClick(Sender: TObject);
Var zaehler2, enc:integer;
    err, Feh1,Feh2: Integer;
    Feh3: String;
begin

  Feh1:=0;
  Feh2:=0;

  For zaehler2:=0 to OpenDialog2.Files.Count-1 do begin

    Attrs := FileGetAttr(OpenDialog2.Files[zaehler2]);
    if not (Attrs and faReadOnly = 0) then begin
      IF Schreibschutz.checked=false then begin
        err:=FileSetAttr(OpenDialog2.Files[zaehler2], Attrs - faReadOnly);
        IF not err=0 then Feh1:=Feh1+1;
      end else
        Feh1:=Feh1+1;

    end;
    if FileGetAttr(OpenDialog2.Files[zaehler2]) and faReadOnly = 0 then begin
      FileHandle:=FileOpen(OpenDialog2.Files[zaehler2], fmOpenReadWrite);
      IF FileHandle=-1 then begin
        Feh2:=Feh2+1
      end else begin
        enc:=FileSetDate(FileHandle, Daten[zaehler2]);
        FileClose(FileHandle);

        if (Attrs and faReadOnly <> 0) and (Schreibschutz.checked=false) then begin
          FileSetAttr(OpenDialog2.Files[zaehler2], Attrs);
        end;
      end;
    end;
  end;

  Feh3:='';
  case schreibschutz.checked of
    false: begin
            case Feh1 of
              0:;
              1: Feh3:=Feh3+' In einem Fall konnte der Schreibschutz nicht'
                           +' entfernt werden (Datentrger schreibgeschtzt).';
              else Feh3:=Feh3+' In ' +Stri(Feh1)+ ' Fllen konnte der'
                            +' Schreibschutz nicht entfernt werden'
                            +' (Datentrger schreibgeschtzt).';
            end;
          end;
    true: begin
            case Feh1 of
              0:;
              1: Feh3:=Feh3+' Eine Datei war schreibgeschtzt.';
              else Feh3:=Feh3+Stri(Feh1)+' Dateien waren schreibgeschtzt.';
            end;
           end;
  end;

  case Feh2 of
    0:;
    1:Feh3:=Feh3+' Bei einer schreibbaren Datei war vermutlich der Datentrger'
                +' schreibgeschtzt, oder die Datei wurde von einem anderen'
                +' Programm verwendet.';

    else Feh3:=Feh3+' Bei '+Stri(Feh2)+' Dateien war vermutlich der'
                 +' Datentrger schreibgeschtzt, oder die Dateien wurden bereits'
                 +' von einem anderen Programm verwendet.';
  end;

  IF Feh3='' then begin
    If OpenDialog2.Files.Count > 1 then
      Feh3:=Stri(OpenDialog2.Files.Count)+' Dateien wurden fehlerlos'
             +' bearbeitet.'
    else
      Feh3:='Die Datei wurde fehlerlos bearbeitet.';
  end else Feh3:=Stri(OpenDialog2.Files.Count)+ ' Dateien wurden bearbeitet,'
               +' davon '+Stri(OpenDialog2.Files.Count-Feh1-Feh2)+' fehlerlos.'
               +Feh3;
  ShowMessage(Feh3);
end;

procedure TForm1.DatenLoeschenClick(Sender: TObject);
begin
  if MessageDlg('Die im Speicher befindlichen Daten '
  + 'werden gelscht.' + #13#10 + 'Ein Zurckschreiben '
  + 'der Dateidaten ist danach nicht mehr mglich.',
  mtWarning, [mbOk, mbCancel], 0)
  = mrOk then begin
    VarArrayRedim(Daten, 2);
    Daten[0]:=0;
    Daten[1]:=0;

    DatenMerken.Enabled := true;
    DatenSchreiben.enabled := false;
    DatenLoeschen.Enabled := false;
  end;
end;

procedure TForm1.SchreibschutzClick(Sender: TObject);
begin
  IF Schreibschutz.checked = true then Schreibschutz.checked:=false
     else Schreibschutz.checked:=true;
end;

procedure TForm1.DatumSetzenClick(Sender: TObject);
var FileTime:TDateTime;
    code, incZeit:integer;
    zaehler2, enc:integer;
    err, Feh1,Feh2: Integer;
    Feh3: String;
begin
  if OpenDialog3.Execute then begin
    Feh1:=0;
    Feh2:=0;

    incZeit:=0;
    if ZeitErhoehen.checked = true then
      incZeit:=StrToInt(Form3.Edit1.Text);

    Val(Form1.Edit_HH.Text, hh, code);
    Val(Form1.Edit_NN.Text, nn, code);
    Val(Form1.Edit_SS.Text, ss, code);
    Val(Form1.Edit_DD.Text, dd, code);
    Val(Form1.Edit_MM.Text, mm, code);
    Val(Form1.Edit_YY.Text, yy, code);
    FileTime:=EncodeDate(yy,mm,dd) + EncodeTime(hh,nn,ss,ms);

    For zaehler2:=0 to OpenDialog3.Files.Count-1 do begin

      Attrs := FileGetAttr(OpenDialog3.Files[zaehler2]);
      if not (Attrs and faReadOnly = 0) then begin
        IF Schreibschutz.checked=false then begin
          err:=FileSetAttr(OpenDialog3.Files[zaehler2], Attrs - faReadOnly);
          IF not err=0 then Feh1:=Feh1+1;
        end else
          Feh1:=Feh1+1;

        end;
        if FileGetAttr(OpenDialog3.Files[zaehler2]) and faReadOnly = 0 then begin
          FileHandle:=FileOpen(OpenDialog3.Files[zaehler2], fmOpenReadWrite);
          IF FileHandle=-1 then begin
            Feh2:=Feh2+1
          end else begin
            enc:=FileSetDate(FileHandle, DateTimeToFileDate(FileTime));
            if ZeitErhoehen.checked = true then
              FileTime:=IncSecond(FileTime,incZeit);
            FileClose(FileHandle);

            if (Attrs and faReadOnly <> 0) and (Schreibschutz.checked=false) then begin
              FileSetAttr(OpenDialog3.Files[zaehler2], Attrs);
            end;
          end;
        end;
      end;

      Feh3:='';
      case schreibschutz.checked of
        false: begin
                case Feh1 of
                0:;
                1: Feh3:=Feh3+' In einem Fall konnte der Schreibschutz nicht'
                             +' entfernt werden (Datentrger schreibgeschtzt).';
                else Feh3:=Feh3+' In ' +Stri(Feh1)+ ' Fllen konnte der'
                              +' Schreibschutz nicht entfernt werden'
                              +' (Datentrger schreibgeschtzt).';
              end;
            end;
      true: begin
              case Feh1 of
                0:;
                1: Feh3:=Feh3+' Eine Datei war schreibgeschtzt.';
                else Feh3:=Feh3+Stri(Feh1)+' Dateien waren schreibgeschtzt.';
              end;
             end;
    end;

    case Feh2 of
      0:;
      1:Feh3:=Feh3+' Bei einer schreibbaren Datei war vermutlich der Datentrger'
                  +' schreibgeschtzt, oder die Datei wurde von einem anderen'
                  +' Programm verwendet.';

      else Feh3:=Feh3+' Bei '+Stri(Feh2)+' Dateien war vermutlich der'
                   +' Datentrger schreibgeschtzt, oder die Dateien wurden bereits'
                   +' von einem anderen Programm verwendet.';
    end;

    IF Feh3='' then begin
      If OpenDialog3.Files.Count > 1 then
        Feh3:=Stri(OpenDialog3.Files.Count)+' Dateien wurden fehlerlos'
               +' bearbeitet.'
      else
        Feh3:='Die Datei wurde fehlerlos bearbeitet.';
    end else Feh3:=Stri(OpenDialog3.Files.Count)+ ' Dateien wurden bearbeitet,'
                 +' davon '+Stri(OpenDialog3.Files.Count-Feh1-Feh2)+' fehlerlos.'
                 +Feh3;
    ShowMessage(Feh3);
  end;
end;

procedure TForm1.ZeitErhoehenClick(Sender: TObject);
begin
  IF ZeitErhoehen.checked = true then begin
    ZeitErhoehen.checked:=false;
    ZeitErhoehen.Caption:= 'dabei Zeitstempel erhhen (deaktiviert)';
  end else begin
    Form3.visible := true;
    Form1.Enabled := false;
    Form3.Edit1.SetFocus;
  end;
end;


end.


