unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, Variants, DateUtils, FileCtrl, ShellAPI, Contnrs;

type
  // Increase time (secs, mins, hours, days, years)
  MyIncTime = record
    s, m, h, d, a: Integer;
  end;

  // Number of errors
  MyErrors = record
    files, dirs, wprotected, fileAccess, dirAccess: Integer;
  end;

  // Remembered date entry.
  MyDateFile = record
    date: Integer;
    filename: String;
    isDirectory: boolean;
  end;

  // The form.
  TForm1 = class(TForm)
    Edit_HH: TEdit;
    Edit_SS: TEdit;
    Edit_DD: TEdit;
    Edit_MM: TEdit;
    Edit_YY: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    OpenFileDate: TMenuItem;
    SaveDate: TMenuItem;
    N1: TMenuItem;
    Quit: TMenuItem;
    OpenDialog_File: TOpenDialog;
    Label_CurrentFiletime: TLabel;
    Edit_NN: TEdit;
    HelpMenu: TMenuItem;
    About: TMenuItem;
    ExtrasMenu: TMenuItem;
    RememberDates: TMenuItem;
    SaveDates: TMenuItem;
    N3: TMenuItem;
    ForgetDates: TMenuItem;
    OpenDialog_Remember: TOpenDialog;
    OptionsMenu: TMenuItem;
    OptWriteProtected: TMenuItem;
    Memo_Filename: TMemo;
    SetDates: TMenuItem;
    OpenDialog_Set: TOpenDialog;
    OptIncreaseTime: TMenuItem;
    OptOriginalTime: TMenuItem;
    RememberDatesRecursive: TMenuItem;
    SetDatesRecursive: TMenuItem;
    OpenDirDate: TMenuItem;
    OptSetDirCreateTime: TMenuItem;
    OptExtrasSetDirTime: TMenuItem;
    OptFilesFirst: TMenuItem;
    OptBreadthFirst: TMenuItem;
    Label_Options: TLabel;
    N2: TMenuItem;
    procedure OpenFileDateClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit_HHChange(Sender: TObject);
    procedure Edit_NNChange(Sender: TObject);
    procedure Edit_SSChange(Sender: TObject);
    procedure Edit_DDChange(Sender: TObject);
    procedure Edit_MMChange(Sender: TObject);
    procedure Edit_YYChange(Sender: TObject);
    procedure SaveDateClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure RememberDatesClick(Sender: TObject);
    procedure SaveDatesClick(Sender: TObject);
    procedure ForgetDatesClick(Sender: TObject);
    procedure OptWriteProtectedClick(Sender: TObject);
    procedure SetDatesClick(Sender: TObject);
    procedure OptOriginalTimeClick(Sender: TObject);
    procedure OpenDirDateClick(Sender: TObject);
    function NumStri(var arg: String): Integer;
    function Stri(number: Integer): String;
    function SetFileAge(const FileName: AnsiString; Age: TFileTime): Boolean;
    function DTToFT(const ADateTime: TDateTime): TFileTime;
    procedure OpenDirDateNow(FileName: String);
    procedure OpenFileDateNow(FileName: String);
    procedure RememberDatesRecursiveClick(Sender: TObject);
    procedure SetDatesRecursiveClick(Sender: TObject);
    function SetRecursiveBF(directory: String; inc: MyIncTime; var DateTime: TDateTime): MyErrors;
    function SetRecursive(directory: String; inc: MyIncTime; var DateTime: TDateTime): MyErrors;
    procedure OptSetDirCreateTimeClick(Sender: TObject);
    function GetIncTime(): MyIncTime;
    procedure FormDestroy(Sender: TObject);
    procedure OptExtrasSetDirTimeClick(Sender: TObject);
    procedure ShowErrors(errs: MyErrors);
    procedure setdate(datestr, filename: String);
    function getDirDateTime(filename: String; var DateTime: TDateTime): Boolean;
    function getFileDateTime(filename: String; var DateTime: TDateTime): Boolean;
    function setFileDateTime(filename: String; DateTime: TDateTime): Boolean;
    function setDirDateTime(filename: String; DateTime: TDateTime): Boolean;
    function ReplaceString(arg, oldString, newString: String): String;
    function IncDateTime(DateTime: TDateTime; inc: MyIncTime): TDateTime;
    procedure SetInputFields(datetime: TDateTime);
    function GetInputFields(): TDateTime;
    procedure RememberRecursive(directory: String);
    procedure OptFilesFirstClick(Sender: TObject);
    procedure OptBreadthFirstClick(Sender: TObject);
    procedure ShowOptions();
    procedure OptIncreaseTimeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure AcceptFiles(var msg: TMessage);
    message WM_DROPFILES;
  end;



var
  Form1: TForm1;
  FileHandle: Integer;
  OpenedFile, OpenedDir: boolean;
  CurrentFileName:String;
  Dates: Variant;
  Dates2: TList; // list of MyDateFile

const
  AskWhichFile: String =
    'ffne Datei zum ndern des Datums...';
  AskWhichDir: String =
    'ffne Verzeichnis zum ndern des Datums...';
  AskRememberWhichFiles: String =
    'Von welchen Dateien soll das Datum gemerkt werden?';
  AskSetWhichFiles: String =
    'Von welchen Dateien soll das Datum gesetzt werden?';
  AskRememberWhichDir: String =
    'Von welchem Verzeichnis soll rekursiv das Datum gemerkt werden?';
  AskSetWhichDir: String =
    'Von welchem Verzeichnis soll rekursiv das Datum gesetzt werden?';
  ErrDate: String =
    'Das eingegebene Datum ist ungltig!'+#13#10
    +'Es wird daher das heutige Datum verwendet.';
  ErrOpenFile: String =
    'Es trat ein unerwarteter Fehler beim ffnen der Datei auf.'
    +' Mglicherweise wird die Datei bereits von einem anderen Programm'
    +' verwendet oder ausgefhrt. Schlieen Sie die Datei oder das Programm'
    +' und versuchen Sie es erneut.';
  ErrOpenDragDrop: String =
    'Die Datei konnte nicht geffnet werden.';
  ErrSaveWriteProtect: String =
    'Der Schreibschutz der Datei kann nicht'
    +' umgangen werden. Prfen Sie, ob der Datentrger'
    +' schreibgeschtzt ist.';
  ErrSaveWriteProtect2: String =
    'Die Datei ist schreibgeschtzt. Deaktivieren Sie'
    +' im Men "Optionen" den Punkt "Schreibgeschtzte'
    +' Dateien nicht bearbeiten" und versuchen Sie es erneut!';
  ErrSaveWriteProtect3: String =
    'Die Datei kann nicht gespeichert werden. Prfen Sie, ob der '
    +' Datentrger schreibgeschtzt ist (z.B. CD-Rom?) !';
  ErrSaveDir: String =
    'Das Verzeichnis kann nicht gespeichert werden. Prfen Sie, ob'
    +' der Datentrger schreibgeschtzt ist (z.B. CD-Rom?) !'
    +' Bitte beachten Sie auch, dass unter Windows 95/98/ME das'
    +' nderungsdatum'
    +' von Verzeichnissen bislang nicht gendert werden kann.';
  ErrSaveNone: String =
    'Es wurde noch keine Datei bzw. kein Verzeichnis geffnet.';
  ErrOpenDir: String =
    'Es trat ein unerwarteter Fehler beim ffnen des'
    +' Verzeichnisses auf.'
    +' Mglicherweise kann nicht auf das Verzeichnis oder dessen'
    +' nderungsdatum zugegriffen werden.'
    +' Bitte beachten Sie auch, dass unter Windows 95/98/ME ein'
    +' Zugriff auf'
    +' das nderungsdatum von Verzeichnissen'
    +' bisweilen nicht mglich ist.';
  MsgForgetDates: String =
    'Die im Speicher befindlichen Daten'
    +' werden gelscht.' + #13#10 + 'Ein Zurckschreiben'
    +' der Dateidaten ist danach nicht mehr mglich.';
  MsgRememberRecursiveWarning: String =
    'Das rekursive Merken der Verzeichnis-Daten (inkl. der Daten fr alle'
    +' darin enthaltenen Dateien und Unterverzeichnisse) kann einige Zeit in'
    +' Anspruch nehmen. Der Datei-Datums-nderer reagiert erst wieder,'
    +' sobald der Vorgang abgeschlossen ist.';
  MsgSetRecursiveWarning: String =
    'Das rekursive Bearbeiten eines Verzeichnisses (inkl. aller darin'
    +' enthaltenen Dateien und Unterverzeichnisse) kann einige Zeit in'
    +' Anspruch nehmen. Der Datei-Datums-nderer reagiert erst wieder,'
    +' sobald der Vorgang abgeschlossen ist.' +#13#10
    +'Beachten Sie: Die nderungen lassen sich nicht rckgngig machen!';
  StrNoFile: String = 'keine Datei geffnet';
  StrFile: String = 'Datei:';
  StrDir: String = 'Verzeichnis:';
  StrOptions: String = 'Optionen:';
  StrOptionsNone: String = 'Optionen: keine';

  ErrRemoveProtection1: String = 'In einem Fall konnte der Schreibschutz nicht'
                             +' entfernt werden (Datentrger schreibgeschtzt).';
  ErrRemoveProtectionN: String = 'In %n% Fllen konnte der'
                              +' Schreibschutz nicht entfernt werden'
                              +' (Datentrger schreibgeschtzt).';
  ErrProtected1: String = 'Eine Datei war schreibgeschtzt.';
  ErrProtectedN: String = '%n% Dateien waren schreibgeschtzt.';
  ErrFileAccess1: String = 'Bei einer schreibbaren Datei war vermutlich der Datentrger'
                  +' schreibgeschtzt, oder die Datei wurde von einem anderen'
                  +' Programm verwendet.';
  ErrFileAccessN: String = 'Bei %n% Dateien war vermutlich der'
                   +' Datentrger schreibgeschtzt, oder die Dateien wurden bereits'
                   +' von einem anderen Programm verwendet.';
  ErrDirAccess1: String = 'Bei einem Verzeichnis konnte kein Datum gesetzt werden.';
  ErrDirAccessN: String = 'Bei %n% Verzeichnissen konnte kein Datum gesetzt werden.';
  MsgDirs1: String = 'ein Verzeichnis';
  MsgDirsN: String = '%n% Verzeichnisse';
  MsgFiles1: String = 'eine Datei';
  MsgFilesN: String = '%n% Dateien';
  MsgDirsFiles: String = '%files% und %dirs% wurden fehlerlos bearbeitet.';
  ErrDirsFiles: String = '%files% und %dirs% wurden bearbeitet, dabei traten Fehler auf:';

  MenuOptOriginalTime: String =
    '- dabei &Original-Dateidatum als Basis nutzen';
  MenuOptOriginalTime_Disabled: String =
    '- dabei &Original-Dateidatum als Basis nutzen (deaktiviert)';
  MenuOptIncreaseTime: String =
    '- dabei &Zeitstempel erhhen (%time% pro Datei)';
  MenuOptIncreaseTime_Disabled: String =
    '- dabei &Zeitstempel erhhen (deaktiviert)';

implementation

uses Unit2, Unit3;

{$R *.DFM}
{$R xp.RES}

// Increase the values of a TDateTime object.
function TForm1.IncDateTime(DateTime: TDateTime; inc: MyIncTime): TDateTime;
begin
  DateTime:=IncSecond(DateTime,inc.s);
  DateTime:=IncMinute(DateTime,inc.m);
  DateTime:=IncHour(DateTime,inc.h);
  DateTime:=IncDay(DateTime,inc.d);
  DateTime:=IncYear(DateTime,inc.a);
  Result := DateTime;
end;

// Get data from the increase time form.
function TForm1.GetIncTime(): MyIncTime;
var
  inc: MyIncTime;
begin
  inc.s:=0;
  inc.m:=0;
  inc.h:=0;
  inc.d:=0;
  inc.a:=0;
  if OptIncreaseTime.checked = true then begin
    inc.s:=StrToInt(Form3.Edit1.Text);
    inc.m:=StrToInt(Form3.Edit2.Text);
    inc.h:=StrToInt(Form3.Edit3.Text);
    inc.d:=StrToInt(Form3.Edit4.Text);
    inc.a:=StrToInt(Form3.Edit5.Text);
  end;
  Result := inc;
end;


// Fill the input fields with date and time values.
procedure TForm1.SetInputFields(datetime: TDateTime);
var
  hhS,nnS,ssS,ddS,mmS,yyS:String;
  hh,nn,ss,ms,dd,mm,yy:Word;
begin
  DecodeDate(datetime,yy,mm,dd);
  DecodeTime(datetime,hh,nn,ss,ms);
  Str(hh, hhS);
  Str(nn, nnS);
  Str(ss, ssS);
  Str(dd, ddS);
  Str(mm, mmS);
  Str(yy, yyS);
  Form1.Edit_HH.Text := hhS;
  Form1.Edit_NN.Text := nnS;
  Form1.Edit_SS.Text := ssS;
  Form1.Edit_DD.Text := ddS;
  Form1.Edit_MM.Text := mmS;
  Form1.Edit_YY.Text := yyS;
end;

// Get date and time values from input fields.
function TForm1.GetInputFields(): TDateTime;
var
  code: Integer;
  hh,nn,ss,ms,dd,mm,yy:Word;
  MyDate, MyTime: TDateTime;
begin
  Val(Form1.Edit_HH.Text, hh, code);
  Val(Form1.Edit_NN.Text, nn, code);
  Val(Form1.Edit_SS.Text, ss, code);
  ms := 0;
  Val(Form1.Edit_DD.Text, dd, code);
  Val(Form1.Edit_MM.Text, mm, code);
  Val(Form1.Edit_YY.Text, yy, code);

  MyTime := EncodeTime(hh,nn,ss,ms);
  if not (TryEncodeDate(yy,mm,dd,MyDate)) then begin
    MessageDlg(ErrDate,mtError,[mbOK],0);
    MyDate := Date();
    Result:=MyDate + MyTime;
    SetInputFields(Result);
  end else begin
    Result:=MyDate + MyTime;
  end;
end;


// Replace all occurrences of a substring.
function TForm1.ReplaceString(arg, oldString, newString: String): String;
var
  tmp: String;
begin
  tmp := '';

  while Pos(oldString, arg) > 0 do begin
    tmp := tmp + copy(arg, 1, Pos(oldString, arg)-1);
    tmp := tmp + newString;
    Delete(arg, 1, Pos(oldString, arg)-1 + Length(oldString));
  end;

  Result := tmp + arg;
end;



function TForm1.getFileDateTime(FileName: String; var DateTime: TDateTime): Boolean;
var
  MyFileHandle: Integer;
  CurrentDate: Integer;
begin
  MyFileHandle:=FileOpen(FileName, fmOpenRead);
  if MyFileHandle=-1 then begin
    Result := false;
  end else begin
    CurrentDate:=FileGetDate(MyFileHandle);
    DateTime:=FileDateToDateTime(CurrentDate);
    FileClose(MyFileHandle);
    Result := true;
  end;
end;

procedure TForm1.OpenFileDateNow(FileName: String);
var DateTime:TDateTime;
  CurrentDate: Integer;
begin
    CurrentFileName:=FileName;

    if not (getFileDateTime(CurrentFileName, DateTime)) then begin
      ShowMessage(ErrOpenFile);
      OpenedFile:=false;
      OpenedDir:=false;
      Memo_Filename.Text:=StrNoFile;
      Label_CurrentFiletime.Caption:='';
    end else begin
      OpenedFile:=true;
      OpenedDir:=false;
      Label_CurrentFiletime.Caption := StrFile + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', DateTime);
      SetInputFields(DateTime);
      Memo_Filename.Text := CurrentFileName;
    end;
end;

// Open a file's timestamp.
procedure TForm1.OpenFileDateClick(Sender: TObject);
begin
  if OpenDialog_File.Execute then begin
    OpenFileDateNow(OpenDialog_File.FileName);
  end;
end;

// Quit the application.
procedure TForm1.QuitClick(Sender: TObject);
begin
  Close;
end;

// Set file date using input params.
// However, we cannot write output to the existing console,
// as this is a GUI app and not a Console app.
procedure TForm1.setdate(datestr, filename: String);
var
  sm_string: String;
  DateTime: TDateTime;
  gotDate: Boolean;
  isDirectory: Boolean;
  isFile: Boolean;
  code: Integer;
  hh,nn,ss,ms,dd,mm,yyyy:Word;
begin
  try
    //This is only needed to run as a "hidden" application:
    Application.ShowMainForm := false;
    Form1.Visible := false;


    gotDate := false;
    isDirectory := false;
    isFile := false;

    if DirectoryExists(filename) then begin
      isDirectory := true;
      gotDate := getDirDateTime(filename, DateTime);
    end else if FileExists(filename) then begin
      isFile := true;
      gotDate := getFileDateTime(filename, DateTime);
    end;

    if gotDate then begin
      case Length(datestr) of
        8: begin
          Val(copy(datestr,1,4),yyyy,code);
          Val(copy(datestr,5,2),mm,code);
          Val(copy(datestr,7,2),dd,code);
          ReplaceDate(DateTime,EncodeDate(yyyy,mm,dd));
        end;
        14: begin
          Val(copy(datestr,1,4),yyyy,code);
          Val(copy(datestr,5,2),mm,code);
          Val(copy(datestr,7,2),dd,code);
          Val(copy(datestr,9,2),hh,code);
          Val(copy(datestr,11,2),nn,code);
          Val(copy(datestr,13,2),ss,code);
          ReplaceDate(DateTime,EncodeDate(yyyy,mm,dd));
          ReplaceTime(DateTime,EncodeTime(hh,nn,ss,0));
        end;
        6: begin
          Val(copy(datestr,1,2),hh,code);
          Val(copy(datestr,3,2),nn,code);
          Val(copy(datestr,5,2),ss,code);
          ReplaceTime(DateTime,EncodeTime(hh,nn,ss,0));
        end;
      else
      end;

      //AllocConsole();
      if isDirectory then begin
        if setDirDateTime(filename, DateTime) then begin
          //Writeln('Okay.');
        end else begin
          //Writeln('Error setting directory date.');
        end;
      end else if isFile then begin
        if setFileDateTime(filename, DateTime) then begin
          //Writeln('Okay.');
        end else begin
          //Writeln('Error setting file date.');
        end;
      end;
      //Readln;
      //FreeConsole();
    end else begin
      //AllocConsole();
      //Writeln('Error: Cannot open file or directory. Use /? to show options.');
      //Readln;
      //FreeConsole();
    end;
  finally
    Application.Terminate;
    //Halt(0);
  end;
end;

// Initialize on application startup.
procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog_File.Title:=AskWhichFile;
  OpenDialog_Remember.Title:=AskRememberWhichFiles;
  OpenDialog_Set.Title:=AskSetWhichFiles;

  Memo_Filename.Text:=StrNoFile;
  Label_CurrentFiletime.Caption:='';
  OpenedFile:=false;
  OpenedDir:=false;
  CurrentFileName:='';
  Dates:=VarArrayCreate([0, 1], varInteger);
  RememberDates.Enabled := true;
  RememberDatesRecursive.Enabled := true;
  SaveDates.enabled := false;
  ForgetDates.Enabled := false;
  DragAcceptFiles(Handle, True);
  SetInputFields(Now);
  ShowOptions();

  if not (ParamCount=0) then begin
    if ParamStr(1) = '/?' then begin
      ShowMessage('Syntax:'+#13#10
       +#13#10
       +'"dda.exe <filename>" opens a file or directory for editing'+#13#10
       //+#13#10
       //+'Options:'+#13#10
       //+'/sc /sa /sm <yyyymmdd>'+#13#10
       +#13#10
       +'"dda.exe /sm <yyyymmdd> <filename>" or'+#13#10
       +'"dda.exe /sm <hhmmss> <filename>" or'+#13#10
       +'"dda.exe /sm <yyyymmddhhmmss> <filename>" sets "last modified" date'
      );
    end else if (LowerCase(ParamStr(1)) = '/sm') and (ParamCount>=3) then begin
      setdate(ParamStr(2), ParamStr(3));
    end else if not (ParamStr(1)[1] = '/') then begin
      if DirectoryExists(ParamStr(1)) then begin
        OpenDirDateNow(ParamStr(1));
      end else if FileExists(ParamStr(1)) then begin
        OpenFileDateNow(ParamStr(1));
      end;
    end;
  end;
  //Application.Terminate;
end;


// Allow files to be dragged & dropped onto the main form.
// Thanks to
// http://www.chami.com/tips/delphi/111196D.html
procedure TForm1.AcceptFiles(var msg: TMessage );
const
  cnMaxFileNameLen = 255;
var
  i, nCount: integer;
  acFileName: array [0..cnMaxFileNameLen] of char;
begin
  // find out how many files we're accepting
  nCount := DragQueryFile( msg.WParam,
                           $FFFFFFFF,
                           acFileName,
                           cnMaxFileNameLen );

  // query Windows one at a time for the file name
  for i := 0 to nCount-1 do
  begin
    DragQueryFile( msg.WParam, i,
                   acFileName, cnMaxFileNameLen );

    // do your thing with the acFileName
    //MessageBox( Handle, acFileName, '', MB_OK );
    if FileExists(acFileName) then begin
      OpenFileDateNow(acFileName);
    end else if DirectoryExists(acFileName) then begin
      OpenDirDateNow(acFileName);
    end else begin
      ShowMessage(ErrOpenDragDrop);
    end;
  end;

  // let Windows know that you're done
  DragFinish( msg.WParam );
end;


// Validate String number (remove non-number chars).
function TForm1.NumStri(var arg: String): Integer;
var
  code, number:Integer;
begin
  if arg='' then begin
    number := 0;
  end else begin
    VAL(arg, number, code);
    Str(number, arg);
  end;
  Result := number;
end;

// Convert Integer to String.
function TForm1.Stri(number: Integer): String;
var arg: string;
begin
  Str(number, arg);
  Stri:=arg;
end;

// Validate h (hours) input.
procedure TForm1.Edit_HHChange(Sender: TObject);
var arg:String;
  number: Integer;
begin
  arg:=Edit_HH.Text;
  number:=NumStri(arg);
  Edit_HH.Text:=arg;
  If (number<0) or (number>23) then Edit_HH.Text:='0';
end;

// Validate min (minutes) input.
procedure TForm1.Edit_NNChange(Sender: TObject);
var arg:String;
  number: Integer;
begin
  arg:=Edit_NN.Text;
  number:=NumStri(arg);
  Edit_NN.Text:=arg;
  IF (number<0) or (number>59) then Edit_NN.Text:='0';
end;

// Validate sec (seconds) input
procedure TForm1.Edit_SSChange(Sender: TObject);
var arg:String;
  number:Integer;
begin
  arg:=Edit_SS.Text;
  number:=NumStri(arg);
  Edit_SS.Text:=arg;
  IF (number<0) or (number>59) then Edit_SS.Text:='0';
end;

// Validate d (day) input.
procedure TForm1.Edit_DDChange(Sender: TObject);
var arg:String;
  number:Integer;
begin
  arg:=Edit_DD.Text;
  number:=NumStri(arg);
  Edit_DD.Text:=arg;
  {Hier fehlt noch eine Routine zum berprfen des Monatstags}
  IF (arg<>'') and ((number<1) or (number>31)) then Edit_DD.Text:='1';
end;

// Validate m (month) input.
procedure TForm1.Edit_MMChange(Sender: TObject);
var arg:String;
  number:Integer;
begin
  arg:=Edit_MM.Text;
  number:=NumStri(arg);
  Edit_MM.Text:=arg;
  IF (arg<>'') and ((number<1) or (number>12)) then Edit_MM.Text:='1';
end;

// Validate y (year) input.
procedure TForm1.Edit_YYChange(Sender: TObject);
var arg:String;
  number: Integer;
begin
  arg:=Edit_YY.Text;
  number:=NumStri(arg);
  Edit_YY.Text:=arg;
  IF (arg<>'') and ((number<1) or (number>9999)) then Edit_YY.Text:='1';
end;


function TForm1.setDirDateTime(filename: String; DateTime: TDateTime): Boolean;
begin
  Result := SetFileAge(filename, DTToFT(DateTime));
end;


function TForm1.setFileDateTime(filename: String; DateTime: TDateTime): Boolean;
var
  MyFileHandle: Integer;
  err, Attrs, CurrentDate:integer;
  F: THandle;
begin
  Result := false;
  if FileGetAttr(filename) and faReadOnly=0 then begin
    MyFileHandle:=FileOpen(filename, fmOpenReadWrite);
    If (MyFileHandle=-1) then begin
      Result := false;
    end else begin
      CurrentDate:=DateTimeToFileDate(DateTime);
      FileSetDate(MyFileHandle, CurrentDate);
      FileClose(MyFileHandle);
      Result := true;
    end;
  end;
end;


// Save the file date to the currently open file or directory.
procedure TForm1.SaveDateClick(Sender: TObject);
var DateTime:TDateTime;
    err, Attrs, CurrentDate:integer;
    F: THandle;
begin
  if OpenedFile then begin
    Attrs := FileGetAttr(CurrentFileName);
    if not (Attrs and faReadOnly = 0) then begin
      IF OptWriteProtected.checked=true then begin
        err:=FileSetAttr(CurrentFileName, Attrs - faReadOnly);
        IF not err=0 then ShowMessage(ErrSaveWriteProtect);
      end else begin
        ShowMessage(ErrSaveWriteProtect2);
      end;
    end;

    if not (setFileDateTime(CurrentFileName, GetInputFields())) then begin
      ShowMessage(ErrSaveWriteProtect3);
    end else begin
      getFileDateTime(CurrentFileName, DateTime);
      Label_CurrentFiletime.Caption := StrFile + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', DateTime);
      if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
          FileSetAttr(CurrentFileName, Attrs);
      end;
    end;

  end else if OpenedDir then begin
    DateTime:=GetInputFields();
    if setDirDateTime(CurrentFileName, DateTime) then begin
      if not (getDirDateTime(CurrentFileName, DateTime)) then begin
      end else begin
        Label_CurrentFiletime.Caption := StrDir + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', DateTime);
      end;
    end else begin
      ShowMessage(ErrSaveDir);
    end;
  end else begin
    ShowMessage(ErrSaveNone);
  end;
end;

// Open about box.
procedure TForm1.AboutClick(Sender: TObject);
begin
  form2.visible:=true;
end;

// Remember multiple file dates.
procedure TForm1.RememberDatesClick(Sender: TObject);
var count:integer;
begin
  if OpenDialog_Remember.Execute then begin
    VarArrayRedim(Dates, OpenDialog_Remember.Files.Count-1);
    For count:=0 to OpenDialog_Remember.Files.Count-1 do begin
      FileHandle:=FileOpen(OpenDialog_Remember.Files[count], fmOpenRead);
      Dates[count]:=FileGetDate(FileHandle);
      FileClose(FileHandle);
    end;
    RememberDates.Enabled := false;
    RememberDatesRecursive.Enabled := false;
    SaveDates.enabled := true;
    ForgetDates.Enabled := true;
  end;
end;

// Show errors after processing multiple files and directories.
procedure TForm1.ShowErrors(errs: MyErrors);
var
  err_string: String;
  tmp: String;
begin
  err_string:='';

  case Form1.OptWriteProtected.checked of
    true: begin
      case errs.wprotected of
        0:;
        1: err_string:=err_string+' '+ErrRemoveProtection1;
      else err_string:=err_string+' '
        +ReplaceString(ErrRemoveProtectionN,'%n%',Stri(errs.wprotected));
      end;
    end;
    false: begin
      case errs.wprotected of
        0:;
        1: err_string:=err_string+' '+ErrProtected1;
      else err_string:=err_string+' '
        +ReplaceString(ErrProtectedN,'%n%',Stri(errs.wprotected));
      end;
    end;
  end;

  case errs.fileAccess of
    0:;
    1:err_string:=err_string+' '+ErrFileAccess1;

  else err_string:=err_string+' '
    +ReplaceString(ErrFileAccessN,'%n%',Stri(errs.fileAccess));
  end;

  case errs.dirAccess of
    0:;
    1:err_string:=err_string+' '+ErrDirAccess1;

  else err_string:=err_string+' '
    +ReplaceString(ErrDirAccessN,'%n%',Stri(errs.dirAccess));
  end;



  if err_string='' then begin
    tmp := MsgDirsFiles;
  end else begin
    tmp := ErrDirsFiles;
  end;

  case errs.files of
    1:tmp:=ReplaceString(tmp,'%files%',MsgFiles1);
    else tmp:=ReplaceString(tmp,'%files%',
      ReplaceString(MsgFilesN,'%n%',Stri(errs.files)) );
  end;
  case errs.dirs of
    1:tmp:=ReplaceString(tmp,'%dirs%',MsgDirs1);
    else tmp:=ReplaceString(tmp,'%dirs%',
      ReplaceString(MsgDirsN,'%n%',Stri(errs.dirs)) );
  end;
  tmp[1] := AnsiUpperCase(tmp[1])[1];
  err_string := tmp + err_string;

  ShowMessage(err_string);

end;

// Save the remembered file dates.
procedure TForm1.SaveDatesClick(Sender: TObject);
Var count: Integer;
    err, Attrs: Integer;
    errs: MyErrors;
    df: MyDateFile;
begin
  errs.files:=0;
  errs.dirs:=0;
  errs.wprotected:=0; // File system write error
  errs.fileAccess:=0; // File write error
  errs.dirAccess:=0; // Directory write error

  if (Dates2<>nil) and (Dates2.Count<>0) then begin
    For count:=0 to Dates2.Count-1 do begin
      df := MyDateFile(Dates2.Items[count]^);
      if df.isDirectory then begin
        if OptExtrasSetDirTime.Checked then begin
          // set directory date
          errs.dirs:=errs.dirs+1;
          if not SetFileAge(df.filename, DTToFT(FileDateToDateTime(df.date))) then
            errs.dirAccess:=errs.dirAccess+1;
        end;
      end else begin
        // set file date
        errs.files:=errs.files+1;
        Attrs := FileGetAttr(df.filename);
        if not (Attrs and faReadOnly = 0) then begin
          IF OptWriteProtected.checked then begin
            err:=FileSetAttr(df.filename, Attrs - faReadOnly);
            IF not err=0 then errs.wprotected:=errs.wprotected+1;
          end else
            errs.wprotected:=errs.wprotected+1;

        end;
        if FileGetAttr(df.filename) and faReadOnly = 0 then begin
          FileHandle:=FileOpen(df.filename, fmOpenReadWrite);
          IF FileHandle=-1 then begin
            errs.fileAccess:=errs.fileAccess+1
          end else begin
            FileSetDate(FileHandle, df.date);
            FileClose(FileHandle);

            if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
              FileSetAttr(df.filename, Attrs);
            end;
          end;
        end;
      end;
    end;


  end else begin
    errs.files:=OpenDialog_Remember.Files.Count;
    For count:=0 to OpenDialog_Remember.Files.Count-1 do begin

      Attrs := FileGetAttr(OpenDialog_Remember.Files[count]);
      if not (Attrs and faReadOnly = 0) then begin
        IF OptWriteProtected.checked then begin
          err:=FileSetAttr(OpenDialog_Remember.Files[count], Attrs - faReadOnly);
          IF not err=0 then errs.wprotected:=errs.wprotected+1;
        end else
          errs.wprotected:=errs.wprotected+1;

      end;
      if FileGetAttr(OpenDialog_Remember.Files[count]) and faReadOnly = 0 then begin
        FileHandle:=FileOpen(OpenDialog_Remember.Files[count], fmOpenReadWrite);
        IF FileHandle=-1 then begin
          errs.fileAccess:=errs.fileAccess+1
        end else begin
          FileSetDate(FileHandle, Dates[count]);
          FileClose(FileHandle);

          if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
            FileSetAttr(OpenDialog_Remember.Files[count], Attrs);
          end;
        end;
      end;
    end;
  end;

  ShowErrors(errs);
end;

// Stop remembering the file dates.
procedure TForm1.ForgetDatesClick(Sender: TObject);
var
  count: Integer;
begin
  if MessageDlg(MsgForgetDates,
  mtWarning, [mbOk, mbCancel], 0)
  = mrOk then begin
    VarArrayRedim(Dates, 2);
    Dates[0]:=0;
    Dates[1]:=0;

    if Dates2<>nil then begin
      try
        for count := 0 to Dates2.Count - 1 do begin
          Dispose(Dates2.Items[count]);
        end;
      finally
        Dates2.Clear;
      end;
    end;


    RememberDates.Enabled := true;
    RememberDatesRecursive.Enabled := true;
    SaveDates.enabled := false;
    ForgetDates.Enabled := false;
  end;
end;

// Toggle option 'Leave out write-protected files'
procedure TForm1.OptWriteProtectedClick(Sender: TObject);
begin
  OptWriteProtected.checked := not OptWriteProtected.checked;
  ShowOptions();
end;

// Set multiple file dates.
procedure TForm1.SetDatesClick(Sender: TObject);
var DateTime:TDateTime;
    inc: MyIncTime;
    count, Attrs, CurrentDate:integer;
    err: Integer;
    errs: MyErrors;
begin
  if OpenDialog_Set.Execute then begin
    errs.files := OpenDialog_Set.Files.Count;
    errs.dirs := 0;
    errs.wprotected:=0;
    errs.fileAccess:=0;
    errs.dirAccess := 0;

    inc := GetIncTime();

    DateTime:=GetInputFields();

    For count:=0 to OpenDialog_Set.Files.Count-1 do begin

      Attrs := FileGetAttr(OpenDialog_Set.Files[count]);
      if not (Attrs and faReadOnly = 0) then begin
        IF OptWriteProtected.checked then begin
          err:=FileSetAttr(OpenDialog_Set.Files[count], Attrs - faReadOnly);
          IF not err=0 then errs.wprotected:=errs.wprotected+1;
        end else
          errs.wprotected:=errs.wprotected+1;

      end;

      if FileGetAttr(OpenDialog_Set.Files[count]) and faReadOnly = 0 then begin
        FileHandle:=FileOpen(OpenDialog_Set.Files[count], fmOpenReadWrite);
        IF FileHandle=-1 then begin
          errs.fileAccess:=errs.fileAccess+1
        end else begin
          if OptOriginalTime.checked = true then begin
            CurrentDate:=FileGetDate(FileHandle);
            DateTime:=FileDateToDateTime(CurrentDate);
            DateTime:=IncDateTime(DateTime,inc);
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
          end else begin
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
            DateTime:=IncDateTime(DateTime,inc);
          end;
          FileClose(FileHandle);

          if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
            FileSetAttr(OpenDialog_Set.Files[count], Attrs);
          end;
        end;
      end;
    end;

    ShowErrors(errs);

  end;
end;



// Toggle option 'Based on original time'
procedure TForm1.OptOriginalTimeClick(Sender: TObject);
begin
  IF OptOriginalTime.checked = true then begin
    OptOriginalTime.checked:=false;
    OptOriginalTime.Caption:= MenuOptOriginalTime_Disabled;
  end else begin
    OptOriginalTime.checked:=true;
    OptOriginalTime.Caption:= MenuOptOriginalTime;
  end;
  ShowOptions();
end;



function TForm1.getDirDateTime(filename: String; var DateTime: TDateTime): Boolean;
var
  F: THandle;
  CurrentDate: Integer;
begin
  F := CreateFileA(PAnsiChar(filename), GENERIC_WRITE,
    FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE, nil,
    OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
  if F = INVALID_HANDLE_VALUE then begin
    Result := false;
  end else begin
    CurrentDate:=FileGetDate(F);
    DateTime:=FileDateToDateTime(CurrentDate);
    CloseHandle(F);
    Result := true;
  end;

end;

procedure TForm1.OpenDirDateNow(FileName: String);
var DateTime:TDateTime;
begin
    CurrentFileName:=FileName;
    if not (getDirDateTime(CurrentFileName, DateTime)) then begin
      ShowMessage(ErrOpenDir);
      OpenedFile:=false;
      OpenedDir:=false;
      Memo_Filename.Text:='';
      Label_CurrentFiletime.Caption:='';
    end else begin
      OpenedFile:=false;
      OpenedDir:=true;
      Label_CurrentFiletime.Caption := StrDir + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', DateTime);
      SetInputFields(DateTime);
      Memo_Filename.Text := CurrentFileName;
    end;
end;

// Open a directory's timestamp.
procedure TForm1.OpenDirDateClick(Sender: TObject);
var FileName:string;
begin
  FileName:='';
  if SelectDirectory(AskWhichDir,'', FileName) then begin
    OpenDirDateNow(FileName);
  end;
end;

// Convert TDateTime to TFileTime.
// Thanks to
// https://forums.codegear.com/thread.jspa?threadID=11125&tstart=0
function TForm1.DTToFT(const ADateTime: TDateTime): TFileTime;
var
ft: TFileTime;
st: TSystemTime;
begin
DateTimeToSystemTime(ADateTime, st);
SystemTimeToFileTime(st, ft);
LocalFileTimeToFileTime(ft, ft);
Result := ft;
end;

// Save a directory's file time (will not work on Windows 95/98/ME).
// Thanks to
// http://www.delphipraxis.net/topic83691_filesetdate+auch+fuer+ordner.html
function TForm1.SetFileAge(Const FileName: AnsiString; Age: TFileTime): Boolean;
var F: THandle;
  b: boolean;
begin
  Result := False;
  F := CreateFileA(PAnsiChar(FileName), GENERIC_WRITE,
    FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE, nil,
    OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
  if F = INVALID_HANDLE_VALUE then Exit;
  b := true;
  if OptSetDirCreateTime.Checked then {CreateTime} b := b AND SetFileTime(F, @Age, nil, nil);
  //{LastAccessTime} b := b and SetFileTime(F, nil, @Age, nil);
  {LastWriteTime}  b := b and SetFileTime(F, nil, nil, @Age);
  Result := b;
  CloseHandle(F);
End;

// Store dates in list object.
procedure TForm1.RememberRecursive(directory: String);
var
  SearchRec: TSearchRec;
  datefileptr: ^MyDateFile;
  F: THandle;
begin
  if not (directory[length(directory)] = '\') then
  directory := directory + '\';

  try
    // Remember directory date.
    F := CreateFileA(PAnsiChar(directory), GENERIC_WRITE,
      FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE, nil,
      OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
    if F = INVALID_HANDLE_VALUE then begin
    end else begin
      New(datefileptr);
      datefileptr^.date:=FileGetDate(F);
      datefileptr^.filename:=directory;
      datefileptr^.isDirectory:=true;
      CloseHandle(F);
      Dates2.Add(datefileptr);
    end;
  finally
  end;


  if FindFirst(directory + '*.*', faDirectory+faReadOnly, SearchRec) = 0 then begin
    repeat
      if (SearchRec.Attr and faDirectory = faDirectory)
      and (not (SearchRec.Name[1] = '.')) then begin
        //Current entry is a directory
        RememberRecursive(directory+SearchRec.Name);
      end else begin
        //entry is a file
        if not (SearchRec.Name[1] = '.') then begin
          // Remember file date.
          New(datefileptr);
          FileHandle:=FileOpen(directory+SearchRec.Name, fmOpenRead);
          datefileptr^.date:=FileGetDate(FileHandle);
          datefileptr^.filename:=directory+SearchRec.Name;
          datefileptr^.isDirectory:=false;
          FileClose(FileHandle);
          Dates2.Add(datefileptr);
        end;
      end;
    until (not (FindNext(SearchRec) = 0));
    FindClose(SearchRec);
  end;
end;

// Remember multiple file dates recursively (i.e. including subdirectories).
procedure TForm1.RememberDatesRecursiveClick(Sender: TObject);
var directory: String;
begin
  if (
    SelectDirectory(AskRememberWhichDir,
  '', directory)
  ) and (
    MessageDlg(MsgRememberRecursiveWarning, mtWarning, mbOKCancel, 0) = mrOk
  ) then begin

    if Dates2<>nil then try
      Dates2.Free;
    finally
    end;
    Dates2 := TList.Create;
    RememberRecursive(directory);

    RememberDates.Enabled := false;
    RememberDatesRecursive.Enabled := false;
    SaveDates.enabled := true;
    ForgetDates.Enabled := true;
  end;
end;


// Set dates recursively (breadth first).
function TForm1.SetRecursiveBF(directory: String;
  inc: MyIncTime;
  var DateTime: TDateTime): MyErrors;
var
  filenameptr, filenameptr2: ^String;
  SearchRec: TSearchRec;
  F: THandle;
  WorkList: TQueue;
  DirList: TStringList;
  FileList: TStringList;
  Age: TFileTime;
  count: Integer;
  err: Integer;
  CurrentDate, Attrs: Integer;
  b: boolean;
label
  AddDirList, AddFileList, EndAddLists;
begin
  Result.files := 0;
  Result.dirs := 0;
  Result.wprotected := 0;
  Result.fileAccess := 0;
  Result.dirAccess := 0;

  if not (directory[length(directory)] = '\') then
  directory := directory + '\';

  New(filenameptr);
  filenameptr^ := directory;

  WorkList := TQueue.Create;
  WorkList.Push(filenameptr);

  while WorkList.Count>0  do begin
    filenameptr := WorkList.Pop;
    if(filenameptr^[length(filenameptr^)] = '\') then begin
      //process directory
      Result.dirs:=Result.dirs+1;

      //set date
      F := CreateFileA(PAnsiChar(filenameptr^), GENERIC_WRITE,
      FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE, nil,
      OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
      if F = INVALID_HANDLE_VALUE then begin
        Result.dirAccess:=Result.dirAccess+1;
      end else begin
        if OptOriginalTime.checked = true then begin
          CurrentDate:=FileGetDate(F);
          DateTime:=FileDateToDateTime(CurrentDate);
          DateTime:=IncDateTime(DateTime,inc);

          Age:=DTToFT(DateTime);
          b := true;
          if OptSetDirCreateTime.Checked then {CreateTime} b := b AND SetFileTime(F, @Age, nil, nil);
          //{LastAccessTime} b := b and SetFileTime(F, nil, @Age, nil);
          {LastWriteTime}  b := b and SetFileTime(F, nil, nil, @Age);
          if b=false then Result.dirAccess:=Result.dirAccess+1;
        end else begin
          Age:=DTToFT(DateTime);
          b := true;
          if OptSetDirCreateTime.Checked then {CreateTime} b := b AND SetFileTime(F, @Age, nil, nil);
          //{LastAccessTime} b := b and SetFileTime(F, nil, @Age, nil);
          {LastWriteTime}  b := b and SetFileTime(F, nil, nil, @Age);
          if b=false then Result.dirAccess:=Result.dirAccess+1;

          DateTime:=IncDateTime(DateTime,inc);
        end;
        CloseHandle(F);

      end;

      //recurse subdirs

      DirList := TStringList.Create;
      FileList := TStringList.Create;

      if FindFirst(filenameptr^ + '*.*', faDirectory+faReadOnly, SearchRec) = 0 then begin
        repeat
          if (SearchRec.Attr and faDirectory = faDirectory)
          and (not (SearchRec.Name[1] = '.')) then begin
            //Current entry is a directory
            DirList.Add(filenameptr^+SearchRec.Name);
          end else begin
            //entry is a file
            if not (SearchRec.Name[1] = '.') then begin
              FileList.Add(filenameptr^+SearchRec.Name);
            end;
          end;
        until (not (FindNext(SearchRec) = 0));
        FindClose(SearchRec);

        // A little "goto" programming for alternate order.
        if OptFilesFirst.Checked then goto AddFileList;

        AddDirList:
        DirList.Sort;
        for count := 0 to DirList.Count-1 do begin
          New(filenameptr2);
          filenameptr2^ := DirList.Strings[count];
          if not (filenameptr2^[length(filenameptr2^)] = '\') then
            filenameptr2^ := filenameptr2^ + '\';
          WorkList.Push(filenameptr2);
        end;
        DirList.Free;
        if OptFilesFirst.Checked then goto EndAddLists;

        AddFileList:
        FileList.Sort;
        for count := 0 to FileList.Count-1 do begin
          New(filenameptr2);
          filenameptr2^ := FileList.Strings[count];
          WorkList.Push(filenameptr2);
        end;
        FileList.Free;
        if OptFilesFirst.Checked then goto AddDirList;

        EndAddLists:

      end;


    end else begin
      //process file
      Result.files:=Result.files+1;

      Attrs := FileGetAttr(filenameptr^);
      if not (Attrs and faReadOnly = 0) then begin
        IF OptWriteProtected.checked then begin
          err:=FileSetAttr(filenameptr^, Attrs - faReadOnly);
          IF not err=0 then Result.wprotected:=Result.wprotected+1;
        end else
          Result.wprotected:=Result.wprotected+1;
      end;

      if FileGetAttr(filenameptr^) and faReadOnly = 0 then begin
        FileHandle:=FileOpen(filenameptr^, fmOpenReadWrite);
        IF FileHandle=-1 then begin
          Result.fileAccess:=Result.fileAccess+1
        end else begin
          if OptOriginalTime.checked = true then begin
            CurrentDate:=FileGetDate(FileHandle);
            DateTime:=FileDateToDateTime(CurrentDate);
            DateTime:=IncDateTime(DateTime,inc);
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
          end else begin
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
            DateTime:=IncDateTime(DateTime,inc);
          end;
          FileClose(FileHandle);

          if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
            FileSetAttr(filenameptr^, Attrs);
          end;
        end;
      end;

    end;
    Dispose(filenameptr);


  end;


end;


// Set dates recursively (depth first).
function TForm1.SetRecursive(directory: String;
  inc: MyIncTime;
  var DateTime: TDateTime): MyErrors;
var
  SearchRec: TSearchRec;
  F: THandle;
  DirList: TStringList;
  FileList: TStringList;
  Age: TFileTime;
  count: Integer;
  err: Integer;
  CurrentDate, Attrs: Integer;
  errs: MyErrors;
  b: boolean;
label
  AddDirList, AddFileList, EndAddLists;
begin
  Result.files := 0;
  Result.dirs := 0;
  Result.wprotected := 0;
  Result.fileAccess := 0;
  Result.dirAccess := 0;

  if not (directory[length(directory)] = '\') then
  directory := directory + '\';

  // process directory
  Result.dirs := Result.dirs+1;

  if OptExtrasSetDirTime.Checked then begin
    //set directory date
    F := CreateFileA(PAnsiChar(directory), GENERIC_WRITE,
    FILE_SHARE_READ or FILE_SHARE_WRITE or FILE_SHARE_DELETE, nil,
    OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, 0);
    if F = INVALID_HANDLE_VALUE then begin
      Result.dirAccess:=Result.dirAccess+1;
    end else begin
      if OptOriginalTime.checked = true then begin
        CurrentDate:=FileGetDate(F);
        DateTime:=FileDateToDateTime(CurrentDate);
        DateTime:=IncDateTime(DateTime,inc);

        Age:=DTToFT(DateTime);
        b := true;
        if OptSetDirCreateTime.Checked then {CreateTime} b := b AND SetFileTime(F, @Age, nil, nil);
        //{LastAccessTime} b := b and SetFileTime(F, nil, @Age, nil);
        {LastWriteTime}  b := b and SetFileTime(F, nil, nil, @Age);
        if b=false then Result.dirAccess:=Result.dirAccess+1;
      end else begin
        Age:=DTToFT(DateTime);
        b := true;
        if OptSetDirCreateTime.Checked then {CreateTime} b := b AND SetFileTime(F, @Age, nil, nil);
        //{LastAccessTime} b := b and SetFileTime(F, nil, @Age, nil);
        {LastWriteTime}  b := b and SetFileTime(F, nil, nil, @Age);
        if b=false then Result.dirAccess:=Result.dirAccess+1;

        DateTime:=IncDateTime(DateTime,inc);
      end;
      CloseHandle(F);

    end;
  end;



  //recurse subdirs

  DirList := TStringList.Create;
  FileList := TStringList.Create;

  if FindFirst(directory + '*.*', faDirectory+faReadOnly, SearchRec) = 0 then begin
    repeat
      if (SearchRec.Attr and faDirectory = faDirectory)
      and (not (SearchRec.Name[1] = '.')) then begin
        //Current entry is a directory
        DirList.Add(directory+SearchRec.Name);
      end else begin
        //entry is a file
        if not (SearchRec.Name[1] = '.') then begin
          FileList.Add(directory+SearchRec.Name);
        end;
      end;
    until (not (FindNext(SearchRec) = 0));
    FindClose(SearchRec);

    // A little "goto" programming for alternate order.
    if OptFilesFirst.Checked then goto AddFileList;

    AddDirList:
    DirList.Sort;
    for count := 0 to DirList.Count-1 do begin
      // process directory recursively
      errs := SetRecursive(DirList.Strings[count],inc,DateTime);
      Result.files := Result.files + errs.files;
      Result.dirs := Result.dirs + errs.dirs;
      Result.wprotected := Result.wprotected + errs.wprotected;
      Result.fileAccess := Result.fileAccess + errs.fileAccess;
      Result.dirAccess := Result.dirAccess + errs.dirAccess;
    end;
    DirList.Free;
    if OptFilesFirst.Checked then goto EndAddLists;

    AddFileList:
    FileList.Sort;
    for count := 0 to FileList.Count-1 do begin
      // process file
      Result.files := Result.files + 1;

      Attrs := FileGetAttr(FileList.Strings[count]);
      if not (Attrs and faReadOnly = 0) then begin
        IF OptWriteProtected.checked then begin
          err:=FileSetAttr(FileList.Strings[count], Attrs - faReadOnly);
          IF not err=0 then Result.wprotected:=Result.wprotected+1;
        end else
          Result.wprotected:=Result.wprotected+1;
      end;

      if FileGetAttr(FileList.Strings[count]) and faReadOnly = 0 then begin
        FileHandle:=FileOpen(FileList.Strings[count], fmOpenReadWrite);
        IF FileHandle=-1 then begin
          Result.fileAccess:=Result.fileAccess+1
        end else begin
          if OptOriginalTime.checked = true then begin
            CurrentDate:=FileGetDate(FileHandle);
            DateTime:=FileDateToDateTime(CurrentDate);
            DateTime:=IncDateTime(DateTime,inc);
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
          end else begin
            FileSetDate(FileHandle, DateTimeToFileDate(DateTime));
            DateTime:=IncDateTime(DateTime,inc);
          end;
          FileClose(FileHandle);

          if (Attrs and faReadOnly <> 0) and (OptWriteProtected.checked) then begin
            FileSetAttr(FileList.Strings[count], Attrs);
          end;
        end;
      end;

    end;
    FileList.Free;
    if OptFilesFirst.Checked then goto AddDirList;

    EndAddLists:

  end;



end;




// Set multiple file dates recursively (i.e. including subdirectories).
procedure TForm1.SetDatesRecursiveClick(Sender: TObject);
var FileName: String;
    DateTime:TDateTime;
    inc: MyIncTime;
    errs: MyErrors;
begin
  if (
    SelectDirectory(AskSetWhichDir,
  '', FileName)
  ) and (
    MessageDlg(MsgSetRecursiveWarning, mtWarning, mbOKCancel, 0) = mrOk
  ) then begin

    inc := GetIncTime();

    DateTime:=GetInputFields();

    if OptBreadthFirst.Checked then begin
      errs := SetRecursiveBF(FileName, inc, DateTime);
    end else begin
      errs := SetRecursive(FileName, inc, DateTime);
    end;
    ShowErrors(errs);

  end;

end;

// Toggle option 'Additionally set directory creation time'
procedure TForm1.OptSetDirCreateTimeClick(Sender: TObject);
begin
  OptSetDirCreateTime.Checked := not (OptSetDirCreateTime.Checked);
  ShowOptions();
end;

// Free memory on application exit.
procedure TForm1.FormDestroy(Sender: TObject);
var
  count: Integer;
begin
  try
    VarArrayRedim(Dates, 2);
    Dates[0]:=0;
    Dates[1]:=0;
  finally
  end;

  if Dates2<>nil then
    try
      for count := 0 to Dates2.Count - 1 do begin
        Dispose(Dates2.Items[count]);
      end;
    finally
      Dates2.Free;
    end;
end;

// Toggle option 'Set directory time when using Extras'
procedure TForm1.OptExtrasSetDirTimeClick(Sender: TObject);
begin
  OptExtrasSetDirTime.Checked := not (OptExtrasSetDirTime.Checked);
  ShowOptions();
end;

// Toggle option 'First set file times, then directory times.'
procedure TForm1.OptFilesFirstClick(Sender: TObject);
begin
  OptFilesFirst.Checked := not OptFilesFirst.Checked;
  ShowOptions();
end;

// Toggle option 'Breadth first search.'
procedure TForm1.OptBreadthFirstClick(Sender: TObject);
begin
  OptBreadthFirst.Checked := not OptBreadthFirst.Checked;
  ShowOptions();
end;

// Show checked options on main form.
procedure TForm1.ShowOptions;
var
  tmp: String;
begin
  if OptOriginalTime.Checked then tmp := tmp + 'T';
  if OptIncreaseTime.Checked then tmp := tmp + 'I';
  if OptWriteProtected.Checked then tmp := tmp + 'W';
  if OptSetDirCreateTime.Checked then tmp := tmp + 'C';
  if OptExtrasSetDirTime.Checked then tmp := tmp + 'D';
  if OptFilesFirst.Checked then tmp := tmp + 'F';
  if OptBreadthFirst.Checked then tmp := tmp + 'B';
  if tmp='' then begin
    Label_Options.Caption := StrOptionsNone;
  end else begin
    Label_Options.Caption := StrOptions + ' ' + tmp;
  end;
end;



// Toggle option 'Increase time'
procedure TForm1.OptIncreaseTimeClick(Sender: TObject);
begin
  Form3.visible := true;
  Form1.Enabled := false;
  Form3.Edit1.SetFocus;
end;

end.

