unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  MyLastValues = record
    s, m, h, d, a: String;
  end;
  TForm3 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Button2: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit5: TEdit;
    procedure ResetInput();
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form3: TForm3;
  //number: Integer;
  LastValues: MyLastValues;


implementation

uses Unit1;

{$R *.dfm}

// Close without changing values:
procedure TForm3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Edit1.Text := LastValues.s;
  Edit2.Text := LastValues.m;
  Edit3.Text := LastValues.h;
  Edit4.Text := LastValues.d;
  Edit5.Text := LastValues.a;
  Form1.enabled := true;
  Form1.ShowOptions();
end;

// Validate String number (remove non-number chars).
function NumStri(var arg: String): Integer;
var
  code, number:Integer;
begin
  VAL(arg, number, code);
  Str(number, arg);
  IF number=0 then arg:='0';
  Result := number;
end;

// Reset input.
procedure TForm3.ResetInput();
begin
  Edit1.Text := '';
  Edit2.Text := '';
  Edit3.Text := '';
  Edit4.Text := '';
  Edit5.Text := '';
end;

{
procedure TForm3.Edit1Change(Sender: TObject);
var strvalue:String;
begin
  strvalue:=Form3.Edit1.Text;
  NumStri(strvalue);
  Form3.Edit1.Text:=strvalue;
  //86400sec = 1d
  If (number>86400) then Form3.Edit1.Text:='86400';
end;
}

procedure TForm3.Button1Click(Sender: TObject);
var sec, min, hrs, ds, yrs: Integer;
    strvalue:String;
begin
  sec:=0;
  min:=0;
  hrs:=0;
  ds:=0;
  yrs:=0;

  strvalue:=Form3.Edit1.Text;
  NumStri(strvalue);
  sec:=StrToInt(strvalue);
  min:=sec div 60;
  sec:=sec mod 60;

  strvalue:=Form3.Edit2.Text;
  NumStri(strvalue);
  min:=min+StrToInt(strvalue);
  hrs:=min div 60;
  min:=min mod 60;

  strvalue:=Form3.Edit3.Text;
  NumStri(strvalue);
  hrs:=hrs+StrToInt(strvalue);
  ds:=hrs div 24;
  hrs:=hrs mod 24;

  strvalue:=Form3.Edit4.Text;
  NumStri(strvalue);
  ds:=ds+StrToInt(strvalue);

  strvalue:=Form3.Edit5.Text;
  NumStri(strvalue);
  yrs:=StrToInt(strvalue);

  Form3.Edit1.Text:=IntToStr(sec);
  Form3.Edit2.Text:=IntToStr(min);
  Form3.Edit3.Text:=IntToStr(hrs);
  Form3.Edit4.Text:=IntToStr(ds);
  Form3.Edit5.Text:=IntToStr(yrs);

  //Form3.Close;
  Form3.Visible := false;
  Form1.Enabled := true;
  Form1.SetFocus;

  if (sec=0) and (min=0) and (hrs=0) and (ds=0) and (yrs=0) then begin
    Form1.OptIncreaseTime.checked:=false;
    Form1.OptIncreaseTime.Caption :=
      Unit1.MenuOptIncreaseTime_Disabled+'...';
  end else begin
    Form1.OptIncreaseTime.checked:=true;
    Form1.OptIncreaseTime.Caption :=
      Form1.ReplaceString(Unit1.MenuOptIncreaseTime, '%time%',
        IntToStr(yrs)+'a '
        + IntToStr(ds)+'d '
        + IntToStr(hrs)+'h '
        + IntToStr(min)+'m '
        + IntToStr(sec)+'s'
      )
      +'...';
  end;
  Form1.ShowOptions();

end;

procedure TForm3.Button2Click(Sender: TObject);
begin
  ResetInput();
end;

procedure TForm3.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Msg: TMsg;
begin
  if (Key = VK_Escape) then begin
    PeekMessage(Msg, 0, WM_CHAR, WM_CHAR, PM_REMOVE); // No BEEP.
    Close;
  end;
end;

procedure TForm3.FormShow(Sender: TObject);
begin
  LastValues.s := Edit1.Text;
  LastValues.m := Edit2.Text;
  LastValues.h := Edit3.Text;
  LastValues.d := Edit4.Text;
  LastValues.a := Edit5.Text;
end;


end.
