unit Config;

// This project is documented using the Doxygen documentation system.
// http://www.doxygen.org
// http://pas2dox.sourceforge.net

{* @file Config.pas
 * @brief Current configuration and string constants.
}

interface

uses
  SysUtils, Classes, IniFiles;

type
  {* @brief contains ALL available timestamps (c,m,a,exifDT,exifDTO,exifDTD) }
  MyTimestamp = record
    created, modified, access, exifDT, exifDTO, exifDTD: TDateTime;
  end;

  {* @brief Increase time (secs, mins, hours, days, years) }
  MyIncTime = record
    s, m, h, d, a: Integer;
  end;

  {* @brief Number of errors }
  MyErrors = record
    files, dirs, wprotected, fileAccess, dirAccess, exifRead, exifWrite: Integer;
  end;

  {* @brief Remembered date entry. }
  MyDateFile = record
    //date: Integer;
    timestamp: MyTimestamp;
    filename: String;
    isDirectory: boolean;
  end;


  function LoadSettingsNow(filename: String; isMainConfig: Boolean = false): Boolean;
  procedure SaveSettingsNow(filename: String; isMainConfig: Boolean = false);

  function GetIncTime(): MyIncTime;
  procedure SetIncTime(sec, min, hrs, ds, yrs: Integer);



const
  // const strings cannot be translated by dxgettext.
  StrIniFile: String = 'DDA.ini';
  StrIniSection: String = 'DDA Settings';
  StrIniFileExt: String = '.ini';
  StrAboutUntranslated: String = '<AboutThisSoftware1.5>';
  // The following text is shown if there is no dxgettext translation
  // for '<AboutThisSoftware1.5>' - thus it should be written in English.
  StrAbout: String =
    '--------------------------------------------------'+#13#10
    +'Der Datei-Datums-nderer V1.5'+#13#10
    +'--------------------------------------------------'+#13#10
    +''+#13#10
    +' 2000-2013 by McSquirrel, Rapax, Rx Entertainment'+#13#10
    +''+#13#10
    +'Finally! A tool nobody should need, but everybody wants to have.'+#13#10
    +'With the Datei-Datums-nderer you can change the filedate of any file you '
    +'want. And you don''t have to pay for it because it is FREE!'+#13#10
    +''+#13#10
    +'Just open a file, change the date, and save the changings. That''s it.'+#13#10
    +''+#13#10
    +'Furthermore, since version 1.1, the Datei-Datums-nderer is able to '
    +'"remember" the filedates of a couple of files, so you can save them back '
    +'all at once. It''s fantastic!'+#13#10
    +''+#13#10
    +'From version 1.2 on, you can even save a new date and time to a couple of '
    +'files at once. If you want to, the time stamp is incremented file-by-file. '
    +'Version 1.3 even allows negative values, as well as increasing/decreasing '
    +'the original time stamp of multiple files. Using Version 1.4, you are able '
    +'to edit a directory''s time stamp or the whole contents of a directory '
    +'(recursively). Keyboard shortcuts provide you with quick access to all '
    +'functions. Wonderful!'+#13#10
    +''+#13#10
    +'Version 1.5 introduces an English user interface as well as full timestamp '
    +'support (created, modified, access) and EXIF support. Save your favourite '
    +'settings for easy restore at next startup.'+#13#10
    +''+#13#10
    +'(For further information, please switch to German and read the German manual.)'+#13#10
    +''+#13#10
    +''+#13#10
    +'Version history'+#13#10
    +'-----------------------'+#13#10
    +'v1.0 (04-Sep-2000): The Datei-Datums-nderer is born. You can change the '
    +'filedate of one file at once. There are bugs when altering '
    +'write-protected files. The info-window is of light blue. '+#13#10
    +''+#13#10
    +'v1.1 (07-Oct-2000): The bug while altering write-protected files has been '
    +'removed. You can tell the DDA how to handle these files.'+#13#10
    +''+#13#10
    +'Furthermore you can let the DDA "remember" the '
    +'filedates of several files located in one directory, '
    +'and save all the dates back by just a click. '+#13#10
    +''+#13#10
    +'v1.2 (27-Feb-2004): Now it''s possible to change the filedate of a couple of files in '
    +'one single step. If you want to, the time stamp is incremented for each '
    +'new file, so you can easily sort them by date then. '
    +'At startup, the input fields now contain actual date and time.'+#13#10
    +''+#13#10
    +'v1.3 (22-Oct-2007): As a new feature, DDA allows you to increase/decrease the original '
    +'time stamps of multiple files. The time difference input form now has '
    +'fields for seconds, minutes, hours, days and years. Oversized values '
    +'(such as 60 seconds) are converted automatically, negative values are '
    +'supported as well.'+#13#10
    +''+#13#10
    +'v1.4 (14-Mar-2009): Finally, DDA can handle directories recursively, and now even '
    +'directory time stamps are supported. Drag & drop allows for opening '
    +'single files quickly, while keyboard shortcuts give you access to all '
    +'DDA functions. The user interface now has the Windows XP look-and-feel. '
    +'Using input parameters, you may integrate DDA into Windows Explorer '
    +'(e.g. by using the "Open with..." menu).'+#13#10
    +''+#13#10
    +'v1.4.1 (18-Oct-2009): When increasing/decreasing time stamps, the sum of all increase '
    +'values (i.e. seconds, minutes etc.) needed to be different from 0 - this '
    +'has been fixed.'+#13#10
    +'Note: This version has been added to CHIP.de download archive on 29-Sep-2010.'+#13#10
    +''+#13#10
    +'v1.5 (11-Aug-2013): DDA now utilizes the Windows API to modify all available '
    +'timestamps (creation date, modified date, access date), you may choose the source '
    +'and target dates independly. Even EXIF data in .jpg files is supported by now '
    +'(based on dEXIF 1.03d, thanks to Gerry McGuire!), so you may correct the '
    +'timestamps of your digital photos, or copy the timestamps from EXIF to the '
    +'filesystem or vice versa.'+#13#10
    +'Date and time input has improved, you may also select to only change one of both, '
    +'and the problem loading/saving odd seconds has gone. All settings may be saved '
    +'as default or to separate settings files, so you may store different settings '
    +'for your common tasks.'+#13#10
    +'The software icon has been redrawn and is now available in a higher resolution. '
    +'Last but not least, the GUI may be switched from German to English (based on '
    +'GNU gettext / dxgettext), and the sourcecode has been cleaned up and documented '
    +'(doxygen).'+#13#10
    +''+#13#10
    +'DDA.exe has been built by the free "Borland Delphi 6 Personal Edition" '
    +'and then has been compressed using "UPX" (the "Ultimate '
    +'Packer for eXecutables").'+#13#10
    +''+#13#10
    +''+#13#10
    +'Future'+#13#10
    +'----------'+#13#10
    +'For further automation, a future version of DDA shall support even more '
    +'command line parameters.'+#13#10
    +''+#13#10
    +'When increasing timestamps, a wizard might help to calculate the time difference '
    +'between the actual value and the desired one.'+#13#10
    +''+#13#10
    +'For saving or further editing of timestamp values, exporting and importing '
    +'.csv files could be helpful.'+#13#10
    +''+#13#10
    +'Saved configuration files could be made available within a "Profiles" menu '
    +'(for easy switching) and supplied as examples.'+#13#10
    +''+#13#10
    +''+#13#10
    +'Author'+#13#10
    +'----------'+#13#10
    +'DDA was written by:'+#13#10
    +''+#13#10
    +'Manuel Haim'+#13#10
    +'Schuetzenstrasse 19'+#13#10
    +'35104 Lichtenfels-Muenden'+#13#10
    +'GERMANY'+#13#10
    ;
    
  // For convenience, the German translation is embedded here:
  StrAboutDE: String =
    '--------------------------------------------------'+#13#10
    +'Der Datei-Datums-nderer V1.5'+#13#10
    +'--------------------------------------------------'+#13#10
    +''+#13#10
    +' 2000-2013 by McSquirrel, Rapax, Rx Entertainment'+#13#10
    +''+#13#10
    +'Na endlich! Ein Tool, das keiner brauchen sollte und doch jeder haben will.'+#13#10
    +'Mit dem Datei-Datums-nderer knnen Sie nach Belieben das nderungsdatum '
    +'einer beliebigen Datei (oder eines Verzeichnisses) ndern. Und Sie brauchen '
    +'noch nicht mal einen Pfennig dazu bezahlen, denn der Datei-Datums-nderer '
    +'ist FREEWARE!'+#13#10
    +''+#13#10
    +'ffnen Sie eine beliebige Datei, ndern Sie das Datum, und speichern Sie sie '
    +'wieder. Fertig.'+#13#10
    +''+#13#10
    +'Des weiteren merkt sich der Datei-Datums-nderer auf Knopfdruck das Datum '
    +'von beliebig vielen Dateien in einem Verzeichnis (wahlweise auch fr alle '
    +'Dateien in Unterverzeichnissen) und speichert es auf Knopfdruck wieder '
    +'zurck. Fantastisch!'+#13#10
    +''+#13#10
    +'Auch knnen Sie eine Reihe von Dateien einheitlich mit einem neuen Datum '
    +'versehen. Datum eintragen, Dateien whlen, fertig. Auf Wunsch wird dabei '
    +'nach jeder Datei der Zeitstempel erhht oder erniedrigt. Sogar das Erhhen '
    +'des Original-Zeitstempels ist mglich. Wunderbar!'+#13#10
    +''+#13#10
    +'Sie mchten mehr aus Ihren Dateien herausholen, neben dem nderungs- auch '
    +'das Erstellungs- und Zugriffsdatum anpassen oder den Zeitstempel mit den '
    +'EXIF-Bilddaten abgleichen? Kein Problem, denn Quell- und Zieldatum sind bei '
    +'allen Aktionen frei whlbar. All ihre Einstellungen knnen Sie '
    +'selbstverstndlich auch speichern. Klasse!'+#13#10
    +''+#13#10
    +''+#13#10
    +'Anwendungsbeispiele'+#13#10
    +'----------------------------------'+#13#10
    +'Bei kleinen nderungen an Dateien mchte man ggf. das ursprngliche '
    +'nderungsdatum beibehalten. Dies ist z.B. bei MP3-Dateien der Fall, wenn '
    +'man nur die ID3-Tags ndert. Die Merk-Funktion von DDA ist hier hilfreich:'+#13#10
    +''+#13#10
    +'- Extras-Men => Daten von mehreren Dateien / Verzeichnis-Inhalt merken'+#13#10
    +'- dann die Dateien mit der jeweiligen Software bearbeiten'+#13#10
    +'- Extras-Men => Daten von mehreren Dateien zurckschreiben'+#13#10
    +'- Extras-Men => Im Speicher befindliche Daten lschen'+#13#10
    +''+#13#10
    +''+#13#10
    +'Bei der Entwicklung von Digitalfotos liefern manche Anbieter die Abzge nach '
    +'Dateidatum sortiert. Hat man am ein oder anderen Bild aber nderungen '
    +'vorgenommen, so bringt dies die Reihenfolge durcheinander. Die Mglichkeit, '
    +'den Dateien wieder einheitliche Zeitstempel zu geben und von Datei zu Datei '
    +'zu erhhen, ist mit DDA gegeben:'+#13#10
    +''+#13#10
    +'- Start-Datum/Uhrzeit im Hauptfenster eintragen'+#13#10
    +'- Extras-Men => dabei Zeitstempel erhhen => Zeitdifferenz eintragen'+#13#10
    +'- Extras-Men => Datum fr mehrere Dateien setzen'+#13#10
    +''+#13#10
    +''+#13#10
    +'Oder, falls die Bilder noch EXIF-Daten enthalten, kann auch der Zeitstempel '
    +'daraus extrahiert und in die Dateiattribute bertragen werden:'+#13#10
    +''+#13#10
    +'- Optionen-Men => Quelldatum: EXIF Date Time Original'+#13#10
    +'- Optionen-Men => Zieldatum: Gendert am'+#13#10
    +'- Extras-Men => dabei Original-Dateidatum als Basis nutzen'+#13#10
    +'- Extras-Men => Datum fr mehrere Dateien setzen'+#13#10
    +''+#13#10
    +''+#13#10
    +'Manche Autoradios, DVD- oder MP3-Player sortieren selbst heute noch die '
    +'Dateien nach ihrem nderungsdatum. Mit DDA knnen leicht alle Dateien und '
    +'Unterverzeichnisse in alphabetischer Reihenfolge mit aufsteigendem Datum '
    +'versehen werden, so dass dem erwarteten Hrgenuss nichts mehr im Wege '
    +'steht:'+#13#10
    +''+#13#10
    +'- Start-Datum/Uhrzeit im Hauptfenster eintragen'+#13#10
    +'- ggf. Optionen-Men => Experten-Einstellungen anpassen'+#13#10
    +'- Extras-Men => dabei Zeitstempel erhhen => Zeitdifferenz eintragen'+#13#10
    +'- Extras-Men => Datum fr Verzeichnis-Inhalt rekursiv setzen'+#13#10
    +''+#13#10
    +'Interessant sind in diesem Zusammenhang auch die Optionen "Erst Dateien, '
    +'dann Unterverzeichnisse" (sorgt dafr, dass zunchst alle Dateien innerhalb '
    +'eines Verzeichnisses in alphabetischer Reihenfolge bearbeitet werden und '
    +'danach mit den enthaltenen Unterverzeichnissen in alphabetischer Reihenfolge '
    +'fortgefahren wird) sowie "Breitensuche statt Tiefensuche" (hierbei werden '
    +'zunchst alle Verzeichnisse der obersten Ebene abgearbeitet, dann alle '
    +'Verzeichnisse der nchsttieferen Ebene usw.).'+#13#10
    +''+#13#10
    +''+#13#10
    +'War die Uhr einer Digitalkamera falsch gestellt, so haben auch die Fotodateien '
    +'ein falsches nderungsdatum. Dies lsst sich mit DDA beheben, indem das '
    +'Original-Dateidatum als Basis genutzt und um eine frei whlbare Zeit nach vorn '
    +'oder hinten verschoben wird:'+#13#10
    +''+#13#10
    +'- Extras-Men => dabei Zeitstempel erhhen => Zeitdifferenz eintragen'+#13#10
    +'- Extras-Men => dabei Original-Dateidatum als Basis nutzen'+#13#10
    +'- Extras-Men => Datum fr mehrere Dateien setzen'+#13#10
    +''+#13#10
    +''+#13#10
    +'Bekannte Fehler und Probleme'+#13#10
    +'-------------------------------------------------'+#13#10
    +'Was wre ein Windows-Proggi ohne Fehler? Naja, wohl irgendwie nicht so '
    +'ganz dasselbe...'+#13#10
    +''+#13#10
    +'Zunchst: Nicht jedes beliebige Datum lsst sich speichern. So werden Sie z.B. '
    +'darauf verzichten mssen, den MP3-Dateien Ihrer Oldies-Sammlung oder Ihren '
    +'eingescannten Familienfotos authentische Daten zu verleihen, nur um sie im '
    +'Windows-Explorer entsprechend nach Erscheinungsjahr zu sortieren. Damals '
    +'gab es noch keine Heimcomputer, und das nderungsdatum ist eben nur im '
    +'Kontext der Erzeugung oder nderung von neuen Dateien innerhalb '
    +'informationsverarbeitender Systeme erfunden worden, nicht aber, um nach '
    +'vllig freiem Belieben gendert zu werden. Zur Kontrolle wird nach dem '
    +'Speichern einer Datei das neu vergebene Datum oberhalb der Eingabefelder '
    +'angezeigt.'+#13#10
    +''+#13#10
    +'blicherweise erscheint jedesmal eine Fehlermeldung, wenn versucht wurde, '
    +'eine Datei zu ffnen bzw. zu schreiben, die gerade von einem anderen '
    +'Programm benutzt wird oder ausgefhrt wird. Manchmal ist eine Datei noch '
    +'auf diese Weise gesperrt, obwohl sie bereits geschlossen wurde. Dann kann '
    +'es helfen, die jeweiligen Programme zu beenden oder sogar den PC neu zu '
    +'starten.'+#13#10
    +''+#13#10
    +'Das Datum des letzten Zugriffs auf eine Datei kann leicht zerstrt werden, '
    +'insbesondere wenn im Windows Explorer beim Navigieren durch Verzeichnisse '
    +'weitere Dateieigenschaften ausgelesen werden (z.B. EXIF-Daten oder ein '
    +'Vorschau-Bild).'+#13#10
    +''+#13#10
    +'Das ndern des Verzeichnisdatums wird von Windows 95, 98 und ME nicht '
    +'untersttzt - hier wren manuelle Eingriffe ins Dateisystem oder die Entwicklung '
    +'eines speziellen Treibers erforderlich. Kleine Programmfehler knnten dabei '
    +'erheblichen Datenverlust zur Folge haben. Mit DDA und einem aktuellen '
    +'Windows-Betriebssystem sind und bleiben Sie jedoch auf der sicheren Seite.'+#13#10
    +''+#13#10
    +'Bei der Mehrfach-Dateiauswahl wird die zuletzt ausgewhlte Datei zuerst '
    +'bearbeitet (das liegt am Windows-Dateifenster), also muss man ggf. die Dateien '
    +'von unten nach oben markieren. Beim Markieren aller Dateien mit Strg-A oder '
    +'dem Maus-Lasso tritt das Problem nicht auf.'+#13#10
    +''+#13#10
    +'Als Sekunden knnen ggf. nur gerade Zahlenwerte gespeichert werden (das '
    +'liegt aber am Dateisystem von Windows).'+#13#10
    +''+#13#10
    +'Wenn eigene Dateien auf der Festplatte pltzlich ein anderes Datum zeigen als '
    +'eine Kopie auf CD-ROM oder in einem ZIP-Archiv, hngt dies mit der Zeitzonen- '
    +'oder Jahreszeit-Einstellung in Windows zusammen. Das Dateisystem aktueller '
    +'Windows-Versionen bercksichtigt unter anderem den Wechsel zwischen '
    +'Sommer- und Winterzeit, d.h. im Winter ist die Zeit von Sommer-Dateien um '
    +'eine Stunde verschoben und umgekehrt. Wer an einem Sommertag um 16:00 '
    +'Uhr ein Bild speichert, der wird im Winter bei derselben Datei 15:00 Uhr lesen '
    +'drfen. Ziemlich verwirrend, insbesondere bei Digitalfotos...'+#13#10
    +''+#13#10
    +''+#13#10
    +'Versionsgeschichte'+#13#10
    +'-------------------------------'+#13#10
    +'v1.0 (04-Sep-2000): Der Datei-Datums-nderer erblickt das Licht der Welt. '
    +'Von jeweils einer Datei lsst sich das nderungsdatum ndern. Beim Umgang '
    +'mit schreibgeschtzten Dateien treten Probleme auf. Das Info-Fenster ist '
    +'hellblau.'+#13#10
    +''+#13#10
    +'v1.1 (07-Okt-2000): Das Problem mit den schreibgeschtzten Dateien wurde '
    +'behoben. ber einen neuen Menpunkt bestimmt der Anwender, wie der DDA '
    +'mit solchen Dateien verfahren soll.'+#13#10
    +'Dieses Info-Fenster ist knigsblau und hat eine Scroolbar bekommen --------------->'+#13#10
    +''+#13#10
    +'Auerdem besteht nun die Mglichkeit, das Datum von mehreren sich in einem '
    +'Verzeichnis befindenden Dateien zu "merken" und auf Knopfdruck wieder '
    +'zurckspeichern.'+#13#10
    +''+#13#10
    +'v1.2 (27-Feb-2004): Auf Anregung eines Benutzers ist es nun mglich, '
    +'mehreren Dateien gleichzeitig ein Datum zuzuweisen. Wahlweise kann der '
    +'Zeitstempel pro Datei automatisch erhht werden, so dass z.B. eine Reihe '
    +'von Dateien aufsteigend nach Alphabet sortiert unterschiedliche Daten '
    +'zugewiesen bekommt.'+#13#10
    +'Weitere Neuigkeit: Die Eingabefelder des DDA enthalten beim Programmstart '
    +'nun schon das aktuelle Datum sowie die Uhrzeit.'+#13#10
    +''+#13#10
    +'v1.3 (22-Okt-2007): Ein weiterer Benutzer uerte den Wunsch, die Original-'
    +'Zeitstempel von mehreren Dateien zu erhhen. Dies kann nun getan werden. '
    +'Auerdem erfolgt die Eingabe der Zeitstempel-Differenz nun nach Sekunden, '
    +'Minuten, Stunden, Tagen und Jahren gegliedert. bergroe Werte (wie z.B. '
    +'60 Sekunden) werden automatisch umgerechnet, erstmals sind auch negative '
    +'Werte erlaubt.'+#13#10
    +''+#13#10
    +'v1.4 (14-Mr-2009): Dank der Anregung eines Benutzers lsst sich jetzt ein '
    +'Verzeichnis komplett mit allen Unterverzeichnissen (rekursiv) bearbeiten. '
    +'Neue Tastenkrzel ermglichen einen schnellen Zugriff auf alle Funktionen (die '
    +'aktivierten Optionen werden direkt im Hauptfenster angezeigt). Einzelne Dateien '
    +'und Verzeichnisse knnen auch auf das Programmfenster gezogen und dort '
    +'fallen gelassen werden, um sie zur Bearbeitung zu ffnen (Drag & Drop).'+#13#10
    +'Das Erscheinungsbild wurde an Windows XP angepasst und leicht berarbeitet. '
    +'Auerdem untersttzt DDA erstmals Eingabeparameter, so dass eine Integration '
    +'in den Windows Explorer (z.B. ber das "ffnen mit..."-Men) mglich ist.'+#13#10
    +''+#13#10
    +'v1.4.1 (18-Okt-2009): Ein Erhhen der Zeitstempel war nicht mglich, wenn die '
    +'Werte fr Sekunden, Minuten usw. in der Summe 0 ergaben - dieser Fehler '
    +'wurde behoben.'+#13#10
    +'Hinweis: Diese Version wurde am 29-Sep-2010 ins Download-Archiv von CHIP.de aufgenommen!'+#13#10
    +''+#13#10
    +'v1.5 (11-Aug-2013): Viele schon lange geplante, teils durch Benutzer '
    +'angeregte nderungen sind in diese Version eingeflossen. Durch die direkte '
    +'Verwendung von Windows-Betriebssystem-Funktionen knnen nun endlich alle '
    +'Dateisystem-Zeitstempel (Erstelldatum, nderungsdatum, Zugriffsdatum) '
    +'flexibel angepasst werden, Quelle und Ziel sind hierbei frei whlbar.'+#13#10
    +'Eine Untersttzung fr EXIF-Zeitstempel in .jpg-Dateien (basierend auf '
    +'dEXIF 1.03d von Gerry McGuire, vielen Dank!) ermglicht eine einfache '
    +'Korrektur des Datums von Digitalfotos oder auch ein Umkopieren zwischen '
    +'Dateisystem- und EXIF-Zeitstempeln.'+#13#10
    +'Neben einer verbesserten Zeit- und Datumseingabe lsst sich jetzt wahlweise '
    +'auch nur die Uhrzeit oder nur das Datum ndern, auerdem werden ungerade '
    +'Sekunden verarbeitet. Alle vorgenommenen Einstellungen lassen sich global '
    +'oder in separaten Dateien speichern, so dass der Benutzer fr spezielle '
    +'Aufgaben eigene Konfigurationsdateien anlegen kann.'+#13#10
    +'Das Programm-Icon wurde komplett neu gezeichnet und liegt jetzt in hherer '
    +'Auflsung vor. '
    +'Zuguterletzt ist die Benutzeroberflche nun wahlweise auf deutsch oder '
    +'englisch anzusehen (basierend auf GNU gettext / dxgettext), und der '
    +'Quellcode wurde weiter bereinigt sowie dokumentiert (doxygen).'+#13#10
    +''+#13#10
    +'Die DDA.exe wurde mit der kostenlosen "Borland Delphi 6 Personal Edition" '
    +'kompiliert und wurde nachtrglich mit "UPX v3.03" (einem Packer fr '
    +'ausfhrbare Dateien) gepackt.'+#13#10
    +''+#13#10
    +''+#13#10
    +'Planung und Ideen'+#13#10
    +'------------------------------'+#13#10
    +'Um DDA weiter zu automatisieren, wren weitere Eingabeparameter denkbar - '
    +'dann knnte man alle DDA-Funktionen leicht in den Windows Explorer '
    +'integrieren oder Verknpfungen erstellen, die bestimmte Funktionen aufrufen.'+#13#10
    +''+#13#10
    +'Beim Erhhen eines Datums knnte eine Hilfsfunktion eingebaut werden, die '
    +'nach Auswahl eines Vorher- und eines Nachher-Datums die gewnschte Zeitdifferenz '
    +'ermittelt.'+#13#10
    +''+#13#10
    +'Zur Sicherung oder weiteren Bearbeitung von Datumswerten knnte es hilfreich '
    +'sein, eine Export- und Import-Funktion fr gemerkte Daten (als csv-Datei) '
    +'zu implementieren.'+#13#10
    +''+#13#10
    +'Gespeicherte Konfigurationsdateien knnten ber das Men als "Profile" '
    +'angeboten und als Beispiele mitgeliefert werden.'+#13#10
    +''+#13#10
    +''+#13#10
    +'Programmautor'+#13#10
    +'------------------------'+#13#10
    +'Mich knnen Sie unter folgender Adresse erreichen:'+#13#10
    +''+#13#10
    +'Manuel Haim'+#13#10
    +'Schtzenstrae 19'+#13#10
    +'35104 Lichtenfels-Mnden'+#13#10
    ;

resourcestring
  // These strings can be translated by dxgettext.
  AskWhichFile =
    'Open date from file...';
  AskWhichDir =
    'Open date from directory...';
  AskRememberWhichFiles =
    'Which files'' dates shall be remembered?';
  AskSetWhichFiles =
    'Which files'' dates shall be set?';
  AskIniWhichFile =
    'Load settings file...';
  AskSaveIniWhichFile =
    'Save settings file...';
  AskRememberWhichDir =
    'Which directory''s dates shall be remembered recursively?';
  AskSetWhichDir =
    'Which directory''s dates shall be set recursively?';
  AskSaveSettings =
    'Disable auto-save of settings permanently?'+#13#10
    +'(If you click "Yes", the file "%s%" will be deleted.)';
  ErrDate =
    'The date you entered is invalid!'+#13#10
    +'Thus, the current date will be used.';
  ErrOpenFile =
    'An unexpected error occured when opening the file.'+#13#10
    +'Maybe the file is running or in use by another program.'
    +' Please close the file or program and try again.';
  ErrOpenFileNoSource =
    'Unspecified source date.'+#13#10
    +'When editing a single file or directory, you must always specify a single source date.'+#13#10
    +'Please select a source date option different from'
    +' "Each selected target date"!';
  ErrOpenFileEXIF =
    'Cannot read EXIF data.'+#13#10
    +'Maybe the file does not contain any EXIF data,'
    +' or the file is in use by another program.'
    +' Please close the file or program and try again.';
  ErrOpenDragDrop =
    'The file could not be opened.';
  ErrSaveWriteProtect =
    'Cannot bypass the file''s write protection.'
    +' Please make sure the medium is not write-protected.';
  ErrSaveWriteProtect2 =
    'The file is write protected. Please enable the option'
    +' "Process write-protected files" in the Options menu'
    +' and try again!';
  ErrSaveWriteProtect3 =
    'Cannot save the file. Please make sure the medium is'
    +' not write-protected (e.g. CD-ROM?) !';
  ErrSaveWriteProtectEXIF =
    'Cannot save the file. Please note that EXIF data can only'
    +' be written to JPG files which already contain EXIF data.'
    +' Please also make sure the medium is'
    +' not write-protected (e.g. CD-ROM?) !';
  ErrSaveDir =
    'Cannot save the directory date. Please make sure the medium is'
    +' not write-protected (e.g. CD-ROM?) !'
    +' Remember that the directory date currently cannot be changed'
    +' when using Windows 95/98/ME.';
  ErrSaveNone =
    'Please open a file or directory first.';
  ErrOpenDir =
    'An unexpected error occured when opening the directory.'
    +' Maybe the directory or its date are not accessible at this time.'
    +' Remember that the directory date currently cannot be accessed'
    +' when using Windows 95/98/ME.';
  ErrLoadIni =
    'Invalid settings file!'+#13#10
    +'Settings have been reset to default values.';
  MsgSaveDates =
    'Please make sure that you did not change source/target date options'
    +' before saving remembered dates, as this may lead to unpredictable'
    +' results!';
  MsgForgetDates =
    'This will remove all remembered dates from memory.' + #13#10
    +' Afterwards, these dates cannot be written back to their files'
    +' anymore.';
  MsgRememberRecursiveSourceTargetWarning =
    'When remembering or saving remembered dates, source and target date options must be identical!' + #13#10
    +'Please select "Each selected target date" or "Same as source date" first!';
  MsgRememberRecursiveWarning =
    'Remembering a directory''s dates recursively (incl. all dates from all'
    +' files and subdirectories contained therein) may take some time.'
    +' Meanwhile, the Datei-Datums-Aenderer may possibly not respond to user'
    +' input.';
  MsgSetRecursiveWarning =
    'Changing a directory''s dates recursively (incl. all dates from all'
    +' files and subdirectories contained therein) may take some time.'
    +' Meanwhile, the Datei-Datums-Aenderer may possibly not respond to user'
    +' input.' +#13#10
    +'Please note: Changes cannot be undone!';
  StrNoFile = 'no file opened - drag file here';
  StrFile = 'File:';
  StrDir = 'Directory:';
  StrSourceVal = 'Original value:';
  StrOptions = 'Options:';
  StrOptionsNone = 'Options: none';

  ErrRemoveProtection1 = 'One time, the write-protection could not be disabled'
                             +' (medium was write-protected).';
  ErrRemoveProtectionN = '%n% times, the write-protection could not be disabled'
                              +' (medium was write-protected).';
  ErrProtected1 = 'One file was write-protected.';
  ErrProtectedN = '%n% files were write-protected.';
  ErrFileAccess1 = 'One file was stored on a write-protected medium'
                  +' or was in use by another program.';
  ErrFileAccessN = '%n% files were stored on a write-protected medium'
                   +' or have been in use by another program.';
  ErrDirAccess1 = 'One directory date could not be set.';
  ErrDirAccessN = '%n% directory dates could not be set.';
  ErrNoExif1 = 'One file had no EXIF data.';
  ErrNoExifN = '%n% files had no EXIF data.';
  MsgDirs1 = 'one directory';
  MsgDirsN = '%n% directories';
  MsgFiles1 = 'one file';
  MsgFilesN = '%n% files';
  MsgDirsFiles = '%files% and %dirs% have been processed without errors.';
  ErrDirsFiles = '%files% and %dirs% have been processed, but with errors:';

  MenuOptOriginalTime =
    '- based on original file date';
  MenuOptOriginalTime_Disabled =
    '- based on original file date (disabled)';
  MenuOptIncreaseTime =
    '- increase timestamp (%time% per file)';
  MenuOptIncreaseTime_Disabled =
    '- increase timestamp (disabled)';
  StrAboutTranslated = '<AboutThisSoftware1.5>'; // should be replaced by gnugettext
  MsgConfigFileVersionWarning =
    'Caution! Your settings file was created by a different DDA version!'
    +' Please consider updating DDA.'+#13#10
    +#13#10
    +'However, the file was loaded, but may lead to unexpected results'
    +' in this version of DDA. You have been warned.';


var
  //FileHandle: Integer;
  OpenedFile, OpenedDir: boolean;
  CurrentFileName, CurrentFileVersion:String;
  CurrentFiletime: TDateTime;
  CurrentFiletimeAvail: boolean;
  CurrentSettings:TMemIniFile;
  DatesList: TList; // list of MyDateFile
  CurrentIncTime:MyIncTime;

  OptTime,
  OptDate,
  OptSource_EachTarget,
  OptSource_Created,
  OptSource_Modified,
  OptSource_Access,
  OptSource_EXIF_DateTime,
  OptSource_EXIF_DateTimeOriginal,
  OptSource_EXIF_DateTimeDigitized,
  OptTarget_Source,
  OptTarget_Created,
  OptTarget_Modified,
  OptTarget_Access,
  OptTarget_EXIF_DateTime,
  OptTarget_EXIF_DateTimeOriginal,
  OptTarget_EXIF_DateTimeDigitized,
  OptWriteProtected,
  OptSetDirCreateTime,
  OptToolsSetDirTime,
  OptFilesFirst,
  OptBreadthFirst,
  OptOriginalTime: Boolean;

  OptLanguage: String;

implementation



{*
 * Load settings from file. On errors, default values are used.
 * @param filename The path to the ini file.
 * @param isMainConfig true if main config is loaded, false if custom config.
 * @return true if valid ini file, false otherwise.
 }
function LoadSettingsNow(filename: String; isMainConfig: Boolean = false): Boolean;
begin
  Result := true;
  CurrentSettings.Rename(filename,true);

  if FileExists(filename) and not CurrentSettings.SectionExists(StrIniSection) then Result := false;

  CurrentFileVersion := CurrentSettings.ReadString(StrIniSection,'Version','');

  OptTime := CurrentSettings.ReadBool(StrIniSection,'OptTime',true);
  OptDate := CurrentSettings.ReadBool(StrIniSection,'OptDate',true);
  OptSource_EachTarget := CurrentSettings.ReadBool(StrIniSection,'OptSource_EachTarget',false);
  OptSource_Created := CurrentSettings.ReadBool(StrIniSection,'OptSource_Created',false);
  OptSource_Modified := CurrentSettings.ReadBool(StrIniSection,'OptSource_Modified',true);
  OptSource_Access := CurrentSettings.ReadBool(StrIniSection,'OptSource_Access',false);
  OptSource_EXIF_DateTime := CurrentSettings.ReadBool(StrIniSection,'OptSource_EXIF_DateTime',false);
  OptSource_EXIF_DateTimeOriginal := CurrentSettings.ReadBool(StrIniSection,'OptSource_EXIF_DateTimeOriginal',false);
  OptSource_EXIF_DateTimeDigitized := CurrentSettings.ReadBool(StrIniSection,'OptSource_EXIF_DateTimeDigitized',false);
  OptTarget_Source := CurrentSettings.ReadBool(StrIniSection,'OptTarget_Source',true);
  OptTarget_Created := CurrentSettings.ReadBool(StrIniSection,'OptTarget_Created',false);
  OptTarget_Modified := CurrentSettings.ReadBool(StrIniSection,'OptTarget_Modified',false);
  OptTarget_Access := CurrentSettings.ReadBool(StrIniSection,'OptTarget_Access',false);
  OptTarget_EXIF_DateTime := CurrentSettings.ReadBool(StrIniSection,'OptTarget_EXIF_DateTime',false);
  OptTarget_EXIF_DateTimeOriginal := CurrentSettings.ReadBool(StrIniSection,'OptTarget_EXIF_DateTimeOriginal',false);
  OptTarget_EXIF_DateTimeDigitized := CurrentSettings.ReadBool(StrIniSection,'OptTarget_EXIF_DateTimeDigitized',false);
  if OptTarget_Source then begin
    OptTarget_Created := OptSource_Created;
    OptTarget_Modified := OptSource_Modified;
    OptTarget_Access := OptSource_Access;
    OptTarget_EXIF_DateTime := OptSource_EXIF_DateTime;
    OptTarget_EXIF_DateTimeOriginal := OptSource_EXIF_DateTimeOriginal;
    OptTarget_EXIF_DateTimeDigitized := OptSource_EXIF_DateTimeDigitized;
  end;
  // TODO: Validate that there is only one source selected.
  OptWriteProtected := CurrentSettings.ReadBool(StrIniSection,'OptWriteProtected',false);
  OptSetDirCreateTime := CurrentSettings.ReadBool(StrIniSection,'OptSetDirCreateTime',false);
  OptToolsSetDirTime := CurrentSettings.ReadBool(StrIniSection,'OptToolsSetDirTime',false);
  OptFilesFirst := CurrentSettings.ReadBool(StrIniSection,'OptFilesFirst',false);
  OptBreadthFirst := CurrentSettings.ReadBool(StrIniSection,'OptBreadthFirst',false);

  OptOriginalTime := CurrentSettings.ReadBool(StrIniSection,'OptOriginalTime',false);

  SetIncTime(
    CurrentSettings.ReadInteger(StrIniSection,'OptIncreaseTimeS',0),
    CurrentSettings.ReadInteger(StrIniSection,'OptIncreaseTimeM',0),
    CurrentSettings.ReadInteger(StrIniSection,'OptIncreaseTimeH',0),
    CurrentSettings.ReadInteger(StrIniSection,'OptIncreaseTimeD',0),
    CurrentSettings.ReadInteger(StrIniSection,'OptIncreaseTimeA',0)
  );

  // language will only be loaded from main configuration file
  if isMainConfig then OptLanguage := CurrentSettings.ReadString(StrIniSection,'OptLanguage','default');
end;

{* Save settings to file.
 * @param filename The path to the ini file.
 * @param isMainConfig true if main config is saved, false if custom config.
 }
procedure SaveSettingsNow(filename: String; isMainConfig: Boolean = false);
begin
  CurrentSettings.Rename(filename,false);
  CurrentSettings.WriteString(StrIniSection,'Version','1.5');

  //Do not save this here...
  //CurrentSettings.WriteBool(StrIniSection,'OptSaveSettings',OptSaveSettings.Checked);

  CurrentSettings.WriteBool(StrIniSection,'OptTime',OptTime);
  CurrentSettings.WriteBool(StrIniSection,'OptDate',OptDate);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_EachTarget',OptSource_EachTarget);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_Created',OptSource_Created);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_Modified',OptSource_Modified);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_Access',OptSource_Access);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_EXIF_DateTime',OptSource_EXIF_DateTime);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_EXIF_DateTimeOriginal',OptSource_EXIF_DateTimeOriginal);
  CurrentSettings.WriteBool(StrIniSection,'OptSource_EXIF_DateTimeDigitized',OptSource_EXIF_DateTimeDigitized);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_Source',OptTarget_Source);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_Created',OptTarget_Created);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_Modified',OptTarget_Modified);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_Access',OptTarget_Access);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_EXIF_DateTime',OptTarget_EXIF_DateTime);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_EXIF_DateTimeOriginal',OptTarget_EXIF_DateTimeOriginal);
  CurrentSettings.WriteBool(StrIniSection,'OptTarget_EXIF_DateTimeDigitized',OptTarget_EXIF_DateTimeDigitized);
  CurrentSettings.WriteBool(StrIniSection,'OptWriteProtected',OptWriteProtected);
  CurrentSettings.WriteBool(StrIniSection,'OptSetDirCreateTime',OptSetDirCreateTime);
  CurrentSettings.WriteBool(StrIniSection,'OptToolsSetDirTime',OptToolsSetDirTime);
  CurrentSettings.WriteBool(StrIniSection,'OptFilesFirst',OptFilesFirst);
  CurrentSettings.WriteBool(StrIniSection,'OptBreadthFirst',OptBreadthFirst);

  CurrentSettings.WriteBool(StrIniSection,'OptOriginalTime',OptOriginalTime);

  CurrentSettings.WriteInteger(StrIniSection,'OptIncreaseTimeS',CurrentIncTime.s);
  CurrentSettings.WriteInteger(StrIniSection,'OptIncreaseTimeM',CurrentIncTime.m);
  CurrentSettings.WriteInteger(StrIniSection,'OptIncreaseTimeH',CurrentIncTime.h);
  CurrentSettings.WriteInteger(StrIniSection,'OptIncreaseTimeD',CurrentIncTime.d);
  CurrentSettings.WriteInteger(StrIniSection,'OptIncreaseTimeA',CurrentIncTime.a);

  // language will only be saved in main configuration file
  if isMainConfig then CurrentSettings. WriteString(StrIniSection,'OptLanguage',OptLanguage);

  try
    CurrentSettings.UpdateFile;
  finally
  end;
//
end;




{*
 * Get data from the increase time form.
 }
function GetIncTime(): MyIncTime;
begin
  Result := CurrentIncTime;
end;



{*
 * Set increase time.
 * @param sec seconds
 * @param min minutes
 * @param hrs hours
 * @param ds days
 * @param yrs years
 }
procedure SetIncTime(sec, min, hrs, ds, yrs: Integer);
begin
  CurrentIncTime.s:=sec;
  CurrentIncTime.m:=min;
  CurrentIncTime.h:=hrs;
  CurrentIncTime.d:=ds;
  CurrentIncTime.a:=yrs;

end;



end.
