unit Unit2;

// This project is documented using the Doxygen documentation system.
// http://www.doxygen.org
// http://pas2dox.sourceforge.net

{* @file Unit2.pas
 * @brief The "about" form's unit (TForm2).
}

{* @class TForm2
 * @brief The "about" form.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, gnugettext, Config;

type
  TForm2 = class(TForm)
    g: TMemo;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure FormRetranslate();
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}


procedure TForm2.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm2.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_Escape) or (Key = VK_Return) then Close;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  TranslateComponent(self); //gnugettext
  if Config.StrAboutTranslated = Config.StrAboutUntranslated then begin
    if GetCurrentLanguage() = 'de_DE' then begin
      g.Lines.Add(Config.StrAboutDE);
    end else begin
      g.Lines.Add(Config.StrAbout);
    end;
  end else begin
    g.Lines.Add(Config.StrAboutTranslated);
  end;
end;

procedure TForm2.FormRetranslate();
begin
  RetranslateComponent(self);
  g.Lines.Clear;
  if Config.StrAboutTranslated = Config.StrAboutUntranslated then begin
    if GetCurrentLanguage() = 'de_DE' then begin
      g.Lines.Add(Config.StrAboutDE);
    end else begin
      g.Lines.Add(Config.StrAbout);
    end;
  end else begin
    g.Lines.Add(Config.StrAboutTranslated);
  end;
end;

end.
