unit Unit1;

// This project is documented using the Doxygen documentation system.
// http://www.doxygen.org
// http://pas2dox.sourceforge.net

{* @file Unit1.pas
 * @brief The main form's unit (TForm1).
}

{* @class TForm1
 * @brief The main form.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, Variants, DateUtils, FileCtrl, ShellAPI, Contnrs, IniFiles,
  ComCtrls, Config, SyncObjs, Buttons, ExtCtrls;

type

  // The form.
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    OpenFileDate: TMenuItem;
    SaveDate: TMenuItem;
    N1: TMenuItem;
    Quit: TMenuItem;
    OpenDialog_File: TOpenDialog;
    Label_Source: TLabel;
    HelpMenu: TMenuItem;
    About: TMenuItem;
    ToolsMenu: TMenuItem;
    RememberDates: TMenuItem;
    SaveDates: TMenuItem;
    N3: TMenuItem;
    ForgetDates: TMenuItem;
    OpenDialog_Remember: TOpenDialog;
    OptionsMenu: TMenuItem;
    OptWriteProtected: TMenuItem;
    Memo_Filename: TMemo;
    SetDates: TMenuItem;
    OpenDialog_Set: TOpenDialog;
    OptIncreaseTime: TMenuItem;
    OptOriginalTime: TMenuItem;
    N9: TMenuItem;
    SetDirDatesLatestFile: TMenuItem;
    RememberDatesRecursive: TMenuItem;
    SetDatesRecursive: TMenuItem;
    OpenDirDate: TMenuItem;
    OptSetDirCreateTime: TMenuItem;
    OptToolsSetDirTime: TMenuItem;
    OptFilesFirst: TMenuItem;
    OptBreadthFirst: TMenuItem;
    N2: TMenuItem;
    N4: TMenuItem;
    OptSaveSettings: TMenuItem;
    N5: TMenuItem;
    SaveSettings: TMenuItem;
    LoadSettings: TMenuItem;
    OptSource: TMenuItem;
    OptSource_Access: TMenuItem;
    OptSource_Created: TMenuItem;
    OptSource_Modified: TMenuItem;
    OptSource_EXIF: TMenuItem;
    OptTarget_Source: TMenuItem;
    OptSource_EachTarget: TMenuItem;
    OptTarget: TMenuItem;
    N7: TMenuItem;
    OptTarget_Created: TMenuItem;
    OptTarget_Modified: TMenuItem;
    OptTarget_Access: TMenuItem;
    OptTarget_EXIF: TMenuItem;
    OptTarget_SelectAll: TMenuItem;
    N6: TMenuItem;
    DateTimePicker_Time: TDateTimePicker;
    DateTimePicker_Date: TDateTimePicker;
    CheckBox_Time: TCheckBox;
    CheckBox_Date: TCheckBox;
    OpenDialog_Ini: TOpenDialog;
    SaveDialog_Ini: TSaveDialog;
    OptBasic: TMenuItem;
    OptExpert: TMenuItem;
    Button_TimeNow: TButton;
    Button_DayToday: TButton;
    OptLang: TMenuItem;
    OptLang_DEFAULT: TMenuItem;
    OptLang_EN: TMenuItem;
    OptLang_DE: TMenuItem;
    N8: TMenuItem;
    OptSource_EXIF_DateTime: TMenuItem;
    OptSource_EXIF_DateTimeOriginal: TMenuItem;
    OptSource_EXIF_DateTimeDigitized: TMenuItem;
    OptTarget_EXIF_DateTime: TMenuItem;
    OptTarget_EXIF_DateTimeOriginal: TMenuItem;
    OptTarget_EXIF_DateTimeDigitized: TMenuItem;
    ComboBox_Source: TComboBox;
    Button_SaveDate: TButton;
    Label_CurrentFiletime: TLabel;
    Button_Refresh: TButton;
    Label_Target: TLabel;
    ComboBox_Target: TComboBox;
    Button_Cancel: TButton;
    Button_LoadFile: TButton;
    Label_Options: TLabel;
    OptAdvanced: TMenuItem;
    OptMainTime: TMenuItem;
    OptLatestSubdir: TMenuItem;
    OptAdvanced2: TMenuItem;
    OptMainTime2: TMenuItem;
    OptFtConversion: TMenuItem;
    OptFtConversion_DEFAULT: TMenuItem;
    OptFtConversion_FileTimeToLocalFileTime: TMenuItem;
    OptFtConversion_SystemTimeToTzSpecificLocalTime: TMenuItem;

    // The main form
    procedure FormCreate(Sender: TObject);
    procedure FormRetranslate();
    procedure FormDestroy(Sender: TObject);

    // File menu
    procedure OpenFileDateClick(Sender: TObject);
    procedure OpenDirDateClick(Sender: TObject);
    procedure SaveDateClick(Sender: TObject);
    procedure LoadSettingsClick(Sender: TObject);
    procedure SaveSettingsClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);

    // Extras/Tools menu
    procedure RememberDatesClick(Sender: TObject);
    procedure RememberDatesRecursiveClick(Sender: TObject);
    procedure SaveDatesClick(Sender: TObject);
    procedure ForgetDatesClick(Sender: TObject);
    procedure SetDatesClick(Sender: TObject);
    procedure SetDatesRecursiveClick(Sender: TObject);
    procedure OptMainTimeClick(Sender: TObject);
    procedure OptOriginalTimeClick(Sender: TObject);
    procedure OptIncreaseTimeClick(Sender: TObject);
    procedure SetDirDatesLatestFileClick(Sender: TObject);

    // Options menu
    procedure OptSource_CreatedClick(Sender: TObject);
    procedure OptSource_ModifiedClick(Sender: TObject);
    procedure OptSource_AccessClick(Sender: TObject);
    procedure OptSource_EXIF_DateTimeClick(Sender: TObject);
    procedure OptSource_EXIF_DateTimeOriginalClick(Sender: TObject);
    procedure OptSource_EXIF_DateTimeDigitizedClick(Sender: TObject);
    procedure OptSource_EachTargetClick(Sender: TObject);
    procedure OptTarget_CreatedClick(Sender: TObject);
    procedure OptTarget_ModifiedClick(Sender: TObject);
    procedure OptTarget_AccessClick(Sender: TObject);
    procedure OptTarget_EXIF_DateTimeClick(Sender: TObject);
    procedure OptTarget_EXIF_DateTimeOriginalClick(Sender: TObject);
    procedure OptTarget_EXIF_DateTimeDigitizedClick(Sender: TObject);
    procedure OptTarget_SelectAllClick(Sender: TObject);
    procedure OptTarget_SourceClick(Sender: TObject);
    procedure OptWriteProtectedClick(Sender: TObject);
    procedure OptSetDirCreateTimeClick(Sender: TObject);
    procedure OptToolsSetDirTimeClick(Sender: TObject);
    procedure OptFilesFirstClick(Sender: TObject);
    procedure OptBreadthFirstClick(Sender: TObject);
    procedure OptSaveSettingsClick(Sender: TObject);

    // Help menu
    procedure AboutClick(Sender: TObject);
    procedure OptLang_ENClick(Sender: TObject);
    procedure OptLang_DEClick(Sender: TObject);
    procedure OptLang_DEFAULTClick(Sender: TObject);

    // Helpers within Unit1
    procedure SetInputFields(datetime: TDateTime);
    function GetInputFields(): TDateTime;
    procedure OpenFileDateNow(FileName: String);
    procedure OpenDirDateNow(FileName: String);
    procedure SaveDateNow();
    procedure ShowOptions(toConfig: Boolean = false);
    procedure ShowErrors(errs: MyErrors);
    procedure InitSettingsNow();
    procedure UpdateIncTime();

    // Console helpers
    procedure setdate(datestr, filename: String);

    // Form
    procedure CheckBox_TimeClick(Sender: TObject);
    procedure CheckBox_DateClick(Sender: TObject);
    procedure Button_TimeNowClick(Sender: TObject);
    procedure Button_DayTodayClick(Sender: TObject);
    procedure ComboBox_SourceChange(Sender: TObject);
    procedure Button_SaveDateClick(Sender: TObject);
    procedure Button_RefreshClick(Sender: TObject);
    procedure ComboBox_TargetChange(Sender: TObject);
    procedure Button_CancelClick(Sender: TObject);
    procedure Button_LoadFileClick(Sender: TObject);
    procedure OptMainTime2Click(Sender: TObject);
    procedure OptLatestSubdirClick(Sender: TObject);
    procedure OptFtConversion_DEFAULTClick(Sender: TObject);
    procedure OptFtConversion_FileTimeToLocalFileTimeClick(
      Sender: TObject);
    procedure OptFtConversion_SystemTimeToTzSpecificLocalTimeClick(
      Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
    procedure AcceptFiles(var msg: TMessage);
    message WM_DROPFILES;
  end;

var
  Form1: TForm1;
  ShowOptions_Semaphore: TCriticalSection;
  ShowOptions_isRunning: Boolean;

implementation

uses Unit2, Unit3, dEXIF, gnugettext, Helpers;

{$R *.DFM}
{$R xp.RES}


{*
 * Initialize on application startup.
 }
procedure TForm1.FormCreate(Sender: TObject);
begin
  //ShowMessage(IntToStr(Helpers.GetOSVersionInfoEx.dwMajorVersion) + '.' +  IntToStr(Helpers.GetOSVersionInfoEx.dwMinorVersion));

  //TP_GlobalIgnoreClassProperty(TAction,'Category');
  TP_GlobalIgnoreClassProperty(TControl,'HelpKeyword');
  //TP_GlobalIgnoreClassProperty(TNotebook,'Pages');
  TranslateComponent(self); //gnugettext

  ShowOptions_Semaphore := TCriticalSection.Create;
  ShowOptions_isRunning := false;

  OpenDialog_File.Title:=AskWhichFile;
  OpenDialog_Remember.Title:=AskRememberWhichFiles;
  OpenDialog_Set.Title:=AskSetWhichFiles;
  OpenDialog_Ini.Title:=AskIniWhichFile;
  SaveDialog_Ini.Title:=AskSaveIniWhichFile;

  Memo_Filename.Text:=StrNoFile;
  Label_CurrentFiletime.Caption:='';
  Button_SaveDate.Enabled := false;
  SaveDate.Enabled := false;
  Button_Refresh.Enabled := false;
  Button_Cancel.Enabled := false;
  OpenedFile:=false;
  OpenedDir:=false;
  CurrentFileName:='';
  RememberDates.Enabled := true;
  RememberDatesRecursive.Enabled := true;
  SaveDates.enabled := false;
  ForgetDates.Enabled := false;
  DragAcceptFiles(Handle, True);
  SetInputFields(Now);
  CurrentIncTime.s := 0;
  CurrentIncTime.m := 0;
  CurrentIncTime.h := 0;
  CurrentIncTime.d := 0;
  CurrentIncTime.a := 0;
  InitSettingsNow();
  ShowOptions();

  // We cannot write output to the existing console here,
  // as this is a GUI app and not a Console app.
  // TODO: Move this into DDA unit, or call it from there.
  if not (ParamCount=0) then begin
    if ParamStr(1) = '/?' then begin
      ShowMessage('Syntax:'+#13#10
       +#13#10
       +'"dda.exe <filename>" opens a file or directory for editing'+#13#10
       +#13#10
       +'"dda.exe /settings <settingsfilename> <filename>" or'+#13#10
       +'"dda.exe /settings <settingsfilename>" starts DDA with settings file'+#13#10
       //+#13#10
       //+'Options:'+#13#10
       //+'/sc /sa /sm <yyyymmdd>'+#13#10
       +#13#10
       +'"dda.exe /sm <yyyymmdd> <filename>" or'+#13#10
       +'"dda.exe /sm <hhmmss> <filename>" or'+#13#10
       +'"dda.exe /sm <yyyymmddhhmmss> <filename>" sets "last modified" date'
      );
    end else if (LowerCase(ParamStr(1)) = '/sm') and (ParamCount>=3) then begin
      setdate(ParamStr(2), ParamStr(3));
    end else if (LowerCase(ParamStr(1)) = '/settings') and (ParamCount>=2) then begin
      if not LoadSettingsNow(ParamStr(2)) then begin
        ShowMessage(ErrLoadIni);
      end else begin
        if Config.CurrentFileVersion <> '1.5' then
          MessageDlg(MsgConfigFileVersionWarning, mtWarning, [mbOK], 0);
      end;
      ShowOptions();
      if(ParamCount>=3) then begin
        if DirectoryExists(ParamStr(3)) then begin
          OpenDirDateNow(ParamStr(3));
        end else if FileExists(ParamStr(3)) then begin
          OpenFileDateNow(ParamStr(3));
        end;
      end;
    end else if not (ParamStr(1)[1] = '/') then begin
      if DirectoryExists(ParamStr(1)) then begin
        OpenDirDateNow(ParamStr(1));
      end else if FileExists(ParamStr(1)) then begin
        OpenFileDateNow(ParamStr(1));
      end;
    end;
  end;
  //Application.Terminate;
end;

{*
 * After language switch, this retranslates all static and dynamic strings.
 }
procedure TForm1.FormRetranslate;
begin
  RetranslateComponent(self);

  OpenDialog_File.Title:=AskWhichFile;
  OpenDialog_Remember.Title:=AskRememberWhichFiles;
  OpenDialog_Set.Title:=AskSetWhichFiles;
  OpenDialog_Ini.Title:=AskIniWhichFile;
  SaveDialog_Ini.Title:=AskSaveIniWhichFile;

  if not (OpenedFile or OpenedDir) then begin
    Memo_Filename.Text:=StrNoFile;
    Label_CurrentFiletime.Caption := '';
  end else begin
    if (OpenedFile) then begin
      if (CurrentFiletimeAvail) then
       Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime)
      else
       Label_CurrentFiletime.Caption := StrSourceVal + ' n/a';
    end else if (OpenedDir) then begin
      if (CurrentFiletimeAvail) then
       Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime)
      else
       Label_CurrentFiletime.Caption := StrSourceVal + ' n/a';
    end;
  end;
  
  if OptIncreaseTime.Checked then begin
    with Config.CurrentIncTime do begin
      OptIncreaseTime.Caption :=
        ReplaceString(MenuOptIncreaseTime, '%time%',
          IntToStr(a)+'a '
          + IntToStr(d)+'d '
          + IntToStr(h)+'h '
          + IntToStr(m)+'m '
          + IntToStr(s)+'s'
        )
        +'...';
    end;
  end;

  OptFtConversion_DEFAULT.Caption := ReplaceString(MenuOptFtConversion_DEFAULT, '%default%', GetDefaultFtConversion());
end;

{*
 * Allow files to be dragged & dropped onto the main form.
 * Thanks to
 * http://www.chami.com/tips/delphi/111196D.html
 }
procedure TForm1.AcceptFiles(var msg: TMessage );
const
  cnMaxFileNameLen = 255;
var
  i, nCount: integer;
  acFileName: array [0..cnMaxFileNameLen] of char;
begin
  // find out how many files we're accepting
  nCount := DragQueryFile( msg.WParam,
                           $FFFFFFFF,
                           acFileName,
                           cnMaxFileNameLen );

  // query Windows one at a time for the file name
  for i := 0 to nCount-1 do
  begin
    DragQueryFile( msg.WParam, i,
                   acFileName, cnMaxFileNameLen );

    // do your thing with the acFileName
    //MessageBox( Handle, acFileName, '', MB_OK );
    if FileExists(acFileName) then begin
      OpenFileDateNow(acFileName);
    end else if DirectoryExists(acFileName) then begin
      OpenDirDateNow(acFileName);
    end else begin
      ShowMessage(ErrOpenDragDrop);
    end;
  end;

  // let Windows know that you're done
  DragFinish( msg.WParam );
end;


{*
 * Free memory on application exit.
 }
procedure TForm1.FormDestroy(Sender: TObject);
begin

  DestroyDatesList(); // Free DatesList memory.
  
  if OptSaveSettings.Checked then
    SaveSettingsNow(ExtractFilePath(Application.ExeName)+StrIniFile, true);

  ShowOptions_Semaphore.Free();
end;


{*
 * Open a file's timestamp (File => Open).
 }
procedure TForm1.OpenFileDateClick(Sender: TObject);
begin
  if OpenDialog_File.Execute then begin
    OpenFileDateNow(OpenDialog_File.FileName);
  end;
end;

{*
 * File =>
 * Open a directory's timestamp.
 }
procedure TForm1.OpenDirDateClick(Sender: TObject);
var FileName:string;
begin
  FileName:='';
  if SelectDirectory(AskWhichDir,'', FileName) then begin
    OpenDirDateNow(FileName);
  end;
end;

{*
 * (File => Save)
 * Save the file date to the currently open file or directory.
 }
procedure TForm1.SaveDateClick(Sender: TObject);
begin
  SaveDateNow();
end;

{*
 * File => Load settings
 }
procedure TForm1.LoadSettingsClick(Sender: TObject);
begin
  if OpenDialog_Ini.Execute then begin
    // For your interest: OptSaveSettings.Checked will not be changed.
    if not LoadSettingsNow(OpenDialog_Ini.FileName) then begin
      ShowMessage(ErrLoadIni);
    end else begin
      if Config.CurrentFileVersion <> '1.5' then
        MessageDlg(MsgConfigFileVersionWarning, mtWarning, [mbOK], 0);
    end;

    ShowOptions();
  end;
end;

{*
 * File => Save settings
 }
procedure TForm1.SaveSettingsClick(Sender: TObject);
begin
  if SaveDialog_Ini.Execute then begin
    // For your interest: OptSaveSettings.Checked will not be saved.
    SaveSettingsNow(ChangeFileExt(SaveDialog_Ini.FileName, StrIniFileExt));
  end;
end;


{*
 * Quit the application (File => Quit).
 }
procedure TForm1.QuitClick(Sender: TObject);
begin
  Close;
end;


{* Extras/Tools =>
 * Remember multiple file dates.
 }
procedure TForm1.RememberDatesClick(Sender: TObject);
var errs: MyErrors;
begin
  if (not (Config.OptSource_EachTarget or Config.OptTarget_Source) ) then begin
    MessageDlg(MsgRememberRecursiveSourceTargetWarning, mtWarning, [mbOK], 0);
  end else begin
    if OpenDialog_Remember.Execute then begin

      errs := RememberList(OpenDialog_Remember.Files);

      RememberDates.Enabled := false;
      RememberDatesRecursive.Enabled := false;
      SaveDates.enabled := true;
      ForgetDates.Enabled := true;

      ShowErrors(errs);
    end;
  end;
end;


{*
 * Extras/Tools =>
 * Remember multiple file dates recursively (i.e. including subdirectories).
 }
procedure TForm1.RememberDatesRecursiveClick(Sender: TObject);
var directory: String;
  errs: MyErrors;
begin
  if (not (Config.OptSource_EachTarget or Config.OptTarget_Source) ) then begin
    MessageDlg(MsgRememberRecursiveSourceTargetWarning, mtWarning, [mbOK], 0);
  end else begin
    if (
      SelectDirectory(AskRememberWhichDir, '', directory)
    ) and (
      MessageDlg(MsgRememberRecursiveWarning, mtWarning, mbOKCancel, 0) = mrOk
    ) then begin

      InitDatesList();
      errs := RememberRecursive(directory);

      RememberDates.Enabled := false;
      RememberDatesRecursive.Enabled := false;
      SaveDates.enabled := true;
      ForgetDates.Enabled := true;

      ShowErrors(errs);
    end;
  end;
end;

{*
 * Extras/Tools =>
 * Save the remembered file dates.
 }
procedure TForm1.SaveDatesClick(Sender: TObject);
var
  errs: MyErrors;
begin
  if (not (Config.OptSource_EachTarget or Config.OptTarget_Source) ) then begin
    MessageDlg(MsgRememberRecursiveSourceTargetWarning, mtWarning, [mbOK], 0);
  end else begin
    if MessageDlg(MsgSaveDates,
    mtWarning, [mbOk, mbCancel], 0)
    = mrOk then begin

      errs := SaveRemembered();
      ShowErrors(errs);
    end;
  end;
end;

{*
 * Extras/Tools =>
 * Stop remembering the file dates.
 }
procedure TForm1.ForgetDatesClick(Sender: TObject);
begin
  if MessageDlg(MsgForgetDates,
  mtWarning, [mbOk, mbCancel], 0)
  = mrOk then begin

    ForgetRemembered();

    RememberDates.Enabled := true;
    RememberDatesRecursive.Enabled := true;
    SaveDates.enabled := false;
    ForgetDates.Enabled := false;
  end;
end;

{*
 * Extras/Tools =>
 * Set multiple file dates.
 }
procedure TForm1.SetDatesClick(Sender: TObject);
var DateTime:TDateTime;
    inc: MyIncTime;
    errs: MyErrors;
begin
  if (OpenDialog_Set.Execute)
   and (MessageDlg(MsgSetMultipleWarning, mtWarning, mbOKCancel, 0) = mrOk)
   then begin

    inc := GetIncTime();

    DateTime:=GetInputFields();

    errs := SetList(OpenDialog_Set.Files, inc, DateTime);


    ShowErrors(errs);

  end;
end;

{*
 * Extras/Tools =>
 * Set multiple file dates recursively (i.e. including subdirectories).
 }
procedure TForm1.SetDatesRecursiveClick(Sender: TObject);
var FileName: String;
    DateTime:TDateTime;
    inc: MyIncTime;
    errs: MyErrors;
begin
  if (
    SelectDirectory(AskSetWhichDir,
  '', FileName)
  ) and (
    MessageDlg(MsgSetRecursiveWarning, mtWarning, mbOKCancel, 0) = mrOk
  ) then begin

    inc := GetIncTime();

    DateTime:=GetInputFields();

    if Config.OptBreadthFirst then begin
      errs := SetRecursiveBF(FileName, inc, DateTime);
    end else begin
      errs := SetRecursive(FileName, inc, DateTime);
    end;
    ShowErrors(errs);

  end;

end;


{*
 * Extras/Tools =>
 * Toggle option 'Based on main window time'
 }
procedure TForm1.OptMainTimeClick(Sender: TObject);
begin
  IF OptMainTime.checked = true then begin
    OptMainTime.checked:=false;
    OptMainTime.Caption:= MenuOptMainTime_Disabled;
    OptOriginalTime.checked:=true;
    OptOriginalTime.Caption:= MenuOptOriginalTime;
  end else begin
    OptMainTime.checked:=true;
    OptMainTime.Caption:= MenuOptMainTime;
    OptOriginalTime.checked:=false;
    OptOriginalTime.Caption:= MenuOptOriginalTime_Disabled;
  end;
  ShowOptions(true);
end;

{*
 * Extras/Tools =>
 * Toggle option 'Based on original time'
 }
procedure TForm1.OptOriginalTimeClick(Sender: TObject);
begin
  IF OptOriginalTime.checked = true then begin
    OptOriginalTime.checked:=false;
    OptOriginalTime.Caption:= MenuOptOriginalTime_Disabled;
    OptMainTime.checked:=true;
    OptMainTime.Caption:= MenuOptMainTime;
  end else begin
    OptOriginalTime.checked:=true;
    OptOriginalTime.Caption:= MenuOptOriginalTime;
    OptMainTime.checked:=false;
    OptMainTime.Caption:= MenuOptMainTime_Disabled;
  end;
  ShowOptions(true);
end;

{*
 * Extras/Tools =>
 * Toggle option 'Increase time'
 }
procedure TForm1.OptIncreaseTimeClick(Sender: TObject);
begin
  Form3.ShowModal(); //writes changes to Config class
  ShowOptions(false); //get changes from Config class
end;

{*
 * Extras/Tools =>
 * Set directory dates to latest file (recursively)
 }
procedure TForm1.SetDirDatesLatestFileClick(Sender: TObject);
var FileName: String;
    DateTime, latest:TDateTime;
    errs: MyErrors;
begin
  if (Config.OptSource_EachTarget) then begin
    MessageDlg(MsgSetDirDatesLatestSourceTargetWarning, mtWarning, [mbOK], 0);
  end else begin

    if (
      SelectDirectory(AskSetWhichDir,
    '', FileName)
    ) and (
      MessageDlg(MsgSetDirDatesLatestRecursiveWarning, mtWarning, mbOKCancel, 0) = mrOk
    ) then begin

      DateTime:=GetInputFields();

      errs := SetDirRecursiveLatest(FileName, DateTime, latest);
      ShowErrors(errs);

    end;

  end;
end;

{*
 * Extras/Tools =>
 * for empty directories, set main window date
 }
procedure TForm1.OptMainTime2Click(Sender: TObject);
begin
  if OptMainTime2.checked = true then begin
    OptMainTime2.checked:=false;
    OptMainTime2.Caption:= MenuOptMainTime2_Disabled;
  end else begin
    OptMainTime2.checked:=true;
    OptMainTime2.Caption:= MenuOptMainTime2;
  end;
  ShowOptions(true);
end;

{*
 * Extras/Tools =>
 * also consider subdirs when looking for latest file
 }
procedure TForm1.OptLatestSubdirClick(Sender: TObject);
begin
  if OptLatestSubdir.checked = true then begin
    OptLatestSubdir.checked:=false;
    OptLatestSubdir.Caption:= MenuOptLatestSubdir_Disabled;
  end else begin
    OptLatestSubdir.checked:=true;
    OptLatestSubdir.Caption:= MenuOptLatestSubdir;
  end;
  ShowOptions(true);
end;


{*
 * Options => Source: Date Created
 }
procedure TForm1.OptSource_CreatedClick(Sender: TObject);
begin
  OptSource_Created.Checked := True;
  OptSource_Modified.Checked := False;
  OptSource_Access.Checked := False;
  OptSource_EXIF.Checked := False;
  OptSource_EXIF_DateTime.Checked := False;
  OptSource_EXIF_DateTimeOriginal.Checked := False;
  OptSource_EXIF_DateTimeDigitized.Checked := False;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: Date Modified
 }
procedure TForm1.OptSource_ModifiedClick(Sender: TObject);
begin
  OptSource_Created.Checked := False;
  OptSource_Modified.Checked := True;
  OptSource_Access.Checked := False;
  OptSource_EXIF.Checked := False;
  OptSource_EXIF_DateTime.Checked := False;
  OptSource_EXIF_DateTimeOriginal.Checked := False;
  OptSource_EXIF_DateTimeDigitized.Checked := False;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: Date Accessed
 }
procedure TForm1.OptSource_AccessClick(Sender: TObject);
begin
  OptSource_Created.Checked := False;
  OptSource_Modified.Checked := False;
  OptSource_Access.Checked := True;
  OptSource_EXIF.Checked := False;
  OptSource_EXIF_DateTime.Checked := False;
  OptSource_EXIF_DateTimeOriginal.Checked := False;
  OptSource_EXIF_DateTimeDigitized.Checked := False;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: EXIF Date => Date Time
 }
procedure TForm1.OptSource_EXIF_DateTimeClick(Sender: TObject);
begin
  OptSource_Created.Checked := False;
  OptSource_Modified.Checked := False;
  OptSource_Access.Checked := False;
  OptSource_EXIF.Checked := True;
  OptSource_EXIF_DateTime.Checked := True;
  OptSource_EXIF_DateTimeOriginal.Checked := False;
  OptSource_EXIF_DateTimeDigitized.Checked := False;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: EXIF Date => Date Time Original
 }
procedure TForm1.OptSource_EXIF_DateTimeOriginalClick(Sender: TObject);
begin
  OptSource_Created.Checked := False;
  OptSource_Modified.Checked := False;
  OptSource_Access.Checked := False;
  OptSource_EXIF.Checked := True;
  OptSource_EXIF_DateTime.Checked := False;
  OptSource_EXIF_DateTimeOriginal.Checked := True;
  OptSource_EXIF_DateTimeDigitized.Checked := False;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: EXIF Date => Date Time Digitized
 }
procedure TForm1.OptSource_EXIF_DateTimeDigitizedClick(Sender: TObject);
begin
  OptSource_Created.Checked := False;
  OptSource_Modified.Checked := False;
  OptSource_Access.Checked := False;
  OptSource_EXIF.Checked := True;
  OptSource_EXIF_DateTime.Checked := False;
  OptSource_EXIF_DateTimeOriginal.Checked := False;
  OptSource_EXIF_DateTimeDigitized.Checked := True;
  OptSource_EachTarget.Checked := False;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Source: Each target
 }
procedure TForm1.OptSource_EachTargetClick(Sender: TObject);
begin
  OptSource_EachTarget.Checked := not OptSource_EachTarget.Checked;
  if OptSource_EachTarget.Checked then begin
    OptSource_Created.Checked := False;
    OptSource_Modified.Checked := False;
    OptSource_Access.Checked := False;
    OptSource_EXIF.Checked := False;
    OptSource_EXIF_DateTime.Checked := False;
    OptSource_EXIF_DateTimeOriginal.Checked := False;
    OptSource_EXIF_DateTimeDigitized.Checked := False;
    OptSource_EachTarget.Checked := True;
    OptTarget_Source.Checked := False;
  end else begin
    OptSource_Created.Checked := False;
    OptSource_Modified.Checked := True;
    OptSource_Access.Checked := False;
    OptSource_EXIF.Checked := False;
    OptSource_EXIF_DateTime.Checked := False;
    OptSource_EXIF_DateTimeOriginal.Checked := False;
    OptSource_EXIF_DateTimeDigitized.Checked := False;
  end;
  ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Options => Target: Same as source
 }
procedure TForm1.OptTarget_SourceClick(Sender: TObject);
begin
  OptTarget_Source.Checked := not OptTarget_Source.Checked;
  if OptTarget_Source.Checked then begin
    OptTarget_Created.Checked := OptSource_Created.Checked;
    OptTarget_Modified.Checked := OptSource_Modified.Checked;
    OptTarget_Access.Checked := OptSource_Access.Checked;
    OptTarget_EXIF_DateTime.Checked := OptSource_EXIF_DateTime.Checked;
    OptTarget_EXIF_DateTimeOriginal.Checked := OptSource_EXIF_DateTimeOriginal.Checked;
    OptTarget_EXIF_DateTimeDigitized.Checked := OptSource_EXIF_DateTimeDigitized.Checked;
    OptSource_EachTarget.Checked := false;
  end;
  ShowOptions(true);
end;

{*
 * Options => Target: Date Created
 }
procedure TForm1.OptTarget_CreatedClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = True) and
    (OptTarget_Modified.Checked = False) and
    (OptTarget_Access.Checked = False) and
    (OptTarget_EXIF_DateTime.Checked = False) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = False) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = False)
  ) then OptTarget_Created.Checked := not OptTarget_Created.Checked;
  ShowOptions(true);
end;

{*
 * Options => Target: Date Modified
 }
procedure TForm1.OptTarget_ModifiedClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = False) and
    (OptTarget_Modified.Checked = True) and
    (OptTarget_Access.Checked = False) and
    (OptTarget_EXIF_DateTime.Checked = False) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = False) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = False)
  ) then OptTarget_Modified.Checked := not OptTarget_Modified.Checked;
  ShowOptions(true);
end;

{*
 * Options => Target: Date Accessed
 }
procedure TForm1.OptTarget_AccessClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = False) and
    (OptTarget_Modified.Checked = False) and
    (OptTarget_Access.Checked = True) and
    (OptTarget_EXIF_DateTime.Checked = False) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = False) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = False)
  ) then OptTarget_Access.Checked := not OptTarget_Access.Checked;
  ShowOptions(true);
end;

{*
 * Options => Target: EXIF Date => Date Time
 }
procedure TForm1.OptTarget_EXIF_DateTimeClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = False) and
    (OptTarget_Modified.Checked = False) and
    (OptTarget_Access.Checked = False) and
    (OptTarget_EXIF_DateTime.Checked = True) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = False) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = False)
  ) then begin
    OptTarget_EXIF_DateTime.Checked := not OptTarget_EXIF_DateTime.Checked;
  end;
  ShowOptions(true);
end;

{*
 * Options => Target: EXIF Date => Date Time Original
 }
procedure TForm1.OptTarget_EXIF_DateTimeOriginalClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = False) and
    (OptTarget_Modified.Checked = False) and
    (OptTarget_Access.Checked = False) and
    (OptTarget_EXIF_DateTime.Checked = False) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = True) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = False)
  ) then begin
    OptTarget_EXIF_DateTimeOriginal.Checked := not OptTarget_EXIF_DateTimeOriginal.Checked;
  end;
  ShowOptions(true);
end;

{*
 * Options => Target: EXIF Date => Date Time Digitized
 }
procedure TForm1.OptTarget_EXIF_DateTimeDigitizedClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = False) and
    (OptTarget_Modified.Checked = False) and
    (OptTarget_Access.Checked = False) and
    (OptTarget_EXIF_DateTime.Checked = False) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = False) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = True)
  ) then begin
    OptTarget_EXIF_DateTimeDigitized.Checked := not OptTarget_EXIF_DateTimeDigitized.Checked;
  end;
  ShowOptions(true);
end;

{*
 * Options => Target: Select all
 }
procedure TForm1.OptTarget_SelectAllClick(Sender: TObject);
begin
  if not (
    (OptTarget_Created.Checked = True) and
    (OptTarget_Modified.Checked = True) and
    (OptTarget_Access.Checked = True) and
    (OptTarget_EXIF_DateTime.Checked = True) and
    (OptTarget_EXIF_DateTimeOriginal.Checked = True) and
    (OptTarget_EXIF_DateTimeDigitized.Checked = True)
  ) then begin
    OptTarget_Created.Checked := True;
    OptTarget_Modified.Checked := True;
    OptTarget_Access.Checked := True;
    OptTarget_EXIF_DateTime.Checked := True;
    OptTarget_EXIF_DateTimeOriginal.Checked := True;
    OptTarget_EXIF_DateTimeDigitized.Checked := True;
  end else begin
    OptTarget_Created.Checked := False;
    OptTarget_Modified.Checked := True;
    OptTarget_Access.Checked := False;
    OptTarget_EXIF_DateTime.Checked := False;
    OptTarget_EXIF_DateTimeOriginal.Checked := False;
    OptTarget_EXIF_DateTimeDigitized.Checked := False;
  end;
  ShowOptions(true);

end;

{*
 * Options =>
 * Toggle option 'Process write-protected files'
 }
procedure TForm1.OptWriteProtectedClick(Sender: TObject);
begin
  OptWriteProtected.checked := not OptWriteProtected.checked;
  ShowOptions(true);
end;

{*
 * Options =>
 * Toggle option 'Additionally set directory creation time'
 }
procedure TForm1.OptSetDirCreateTimeClick(Sender: TObject);
begin
  OptSetDirCreateTime.Checked := not (OptSetDirCreateTime.Checked);
  ShowOptions(true);
end;

{*
 * Options =>
 * File time conversion algorithm... =>
 * System default
 }
procedure TForm1.OptFtConversion_DEFAULTClick(Sender: TObject);
begin
  OptFtConversion_DEFAULT.Checked := true;
  OptFtConversion_FileTimeToLocalFileTime.Checked := false;
  OptFtConversion_SystemTimeToTzSpecificLocalTime.Checked := false;
  ShowOptions(true);
end;

{*
 * Options =>
 * File time conversion algorithm... =>
 * FileTimeToLocalFileTime
 }
procedure TForm1.OptFtConversion_FileTimeToLocalFileTimeClick(
  Sender: TObject);
begin
  OptFtConversion_DEFAULT.Checked := false;
  OptFtConversion_FileTimeToLocalFileTime.Checked := true;
  OptFtConversion_SystemTimeToTzSpecificLocalTime.Checked := false;
  ShowOptions(true);
end;

{*
 * Options =>
 * File time conversion algorithm... =>
 * SystemTimeToTzSpezificLocalTime
 }
procedure TForm1.OptFtConversion_SystemTimeToTzSpecificLocalTimeClick(
  Sender: TObject);
begin
  OptFtConversion_DEFAULT.Checked := false;
  OptFtConversion_FileTimeToLocalFileTime.Checked := false;
  OptFtConversion_SystemTimeToTzSpecificLocalTime.Checked := true;
  ShowOptions(true);
end;

{*
 * Options =>
 * Toggle option 'Set directory time when using Extras'
 }
procedure TForm1.OptToolsSetDirTimeClick(Sender: TObject);
begin
  OptToolsSetDirTime.Checked := not (OptToolsSetDirTime.Checked);
  ShowOptions(true);
end;

{*
 * Options =>
 * Toggle option 'First set file times, then directory times'
 }
procedure TForm1.OptFilesFirstClick(Sender: TObject);
begin
  OptFilesFirst.Checked := not OptFilesFirst.Checked;
  ShowOptions(true);
end;

{*
 * Options =>
 * Toggle option 'Breadth first search'
 }
procedure TForm1.OptBreadthFirstClick(Sender: TObject);
begin
  OptBreadthFirst.Checked := not OptBreadthFirst.Checked;
  ShowOptions(true);
end;

{*
 * Options =>
 * Toggle option 'Save settings'
 }
procedure TForm1.OptSaveSettingsClick(Sender: TObject);
var dlgResult: Integer;
begin
  if OptSaveSettings.Checked then begin
    dlgResult := MessageDlg(ReplaceString(AskSaveSettings, '%s%', StrIniFile), mtConfirmation, [mbYes,mbNo], 0);
    if dlgResult = mrYes then begin
      CurrentSettings.DeleteKey(StrIniSection,'OptSaveSettings');
      DeleteFile(ExtractFilePath(Application.ExeName)+StrIniFile);
    end else if dlgResult = mrNo then begin
    end;

  end;
  OptSaveSettings.Checked := not OptSaveSettings.Checked;
  ShowOptions(true);
end;

{*
 * ? =>
 * Language: System default
 }
procedure TForm1.OptLang_DEFAULTClick(Sender: TObject);
begin
  UseLanguage('');
  FormRetranslate();
  if Form2<>nil then Form2.FormRetranslate();
  if Form3<>nil then RetranslateComponent(Form3);
  OptLang_DEFAULT.Checked := true;
  OptLang_EN.Checked := false;
  OptLang_DE.Checked := false;
  ShowOptions(true);
end;

{*
 * ? =>
 * Language: English
 }
procedure TForm1.OptLang_ENClick(Sender: TObject);
begin
  UseLanguage('en_US');
  FormRetranslate();
  if Form2<>nil then Form2.FormRetranslate();
  if Form3<>nil then RetranslateComponent(Form3);
  OptLang_DEFAULT.Checked := false;
  OptLang_EN.Checked := true;
  OptLang_DE.Checked := false;
  ShowOptions(true);
end;

{*
 * ? =>
 * Language: German
 }
procedure TForm1.OptLang_DEClick(Sender: TObject);
begin
  UseLanguage('de_DE');
  FormRetranslate();
  if Form2<>nil then Form2.FormRetranslate();
  if Form3<>nil then RetranslateComponent(Form3);
  OptLang_DEFAULT.Checked := false;
  OptLang_EN.Checked := false;
  OptLang_DE.Checked := true;
  ShowOptions(true);
end;

{*
 * ? =>
 * Open about box.
 }
procedure TForm1.AboutClick(Sender: TObject);
begin
  Form2.Show();
end;



{*
 * Fill the input fields with date and time values.
 }
procedure TForm1.SetInputFields(datetime: TDateTime);
begin
  DateTimePicker_Time.DateTime := datetime;
  DateTimePicker_Date.DateTime := datetime;
end;

{*
 * Get date and time values from input fields.
 }
function TForm1.GetInputFields(): TDateTime;
begin
  Result := Frac(DateTimePicker_Time.DateTime) + Trunc(DateTimePicker_Date.DateTime);
end;




{*
 * This opens a single file. It is called...
 * - by File => Open file
 * - by command line parameter
 * - by drag&drop a file onto the window
 }
procedure TForm1.OpenFileDateNow(FileName: String);
var DateTime:TDateTime;
  //CurrentDate: Integer;
begin
    CurrentFileName:=FileName;
    Memo_Filename.Text := CurrentFileName;
    OpenedFile:=true;
    OpenedDir:=false;

    Button_SaveDate.Enabled := true;
    SaveDate.Enabled := true;
    Button_Refresh.Enabled := true;
    Button_Cancel.Enabled := true;

    if not (getFileDateTime(CurrentFileName, DateTime)) then begin
      if Config.OptSource_EachTarget then begin
        ShowMessage(ErrOpenFileNoSource);
      end else if (Config.OptSource_EXIF_DateTime or Config.OptSource_EXIF_DateTimeOriginal or Config.OptSource_EXIF_DateTimeDigitized) then begin
        ShowMessage(ErrOpenFileEXIF);
      end else if (Config.OptTarget_EXIF_DateTime or Config.OptTarget_EXIF_DateTimeOriginal or Config.OptTarget_EXIF_DateTimeDigitized) then begin
        ShowMessage(ErrOpenFileEXIF);
      end else begin
        ShowMessage(ErrOpenFile);
        OpenedFile:=false;
        OpenedDir:=false;
        Memo_Filename.Text:=StrNoFile;
        Button_SaveDate.Enabled := false;
        SaveDate.Enabled := false;
        Button_Refresh.Enabled := false;
        Button_Cancel.Enabled := false;
      end;
      Label_CurrentFiletime.Caption:= StrSourceVal + ' n/a';
      CurrentFiletimeAvail:=false;
    end else begin
      CurrentFiletime:=DateTime;
      CurrentFiletimeAvail:=true;
      Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime);
      SetInputFields(DateTime);
    end;
end;


{*
 * This opens a single dir. It is called...
 * - by File => Open directory
 * - by command line parameter
 * - by drag&drop a file onto the window
 }
procedure TForm1.OpenDirDateNow(FileName: String);
var DateTime:TDateTime;
begin
    CurrentFileName:=FileName;
    Memo_Filename.Text := CurrentFileName;
    OpenedFile:=false;
    OpenedDir:=true;

    Button_SaveDate.Enabled := true;
    SaveDate.Enabled := true;
    Button_Refresh.Enabled := true;
    Button_Cancel.Enabled := true;

    if not (getDirDateTime(CurrentFileName, DateTime)) then begin
      if Config.OptSource_EachTarget then begin
        ShowMessage(ErrOpenFileNoSource);
      end else if (Config.OptSource_EXIF_DateTime or Config.OptSource_EXIF_DateTimeOriginal or Config.OptSource_EXIF_DateTimeDigitized) then begin
        ShowMessage(ErrOpenFileEXIF);
      end else begin
        ShowMessage(ErrOpenDir);
        OpenedFile:=false;
        OpenedDir:=false;
        Memo_Filename.Text:='';
        Button_SaveDate.Enabled := false;
        SaveDate.Enabled := false;
        Button_Refresh.Enabled := false;
        Button_Cancel.Enabled := false;
      end;
      Label_CurrentFiletime.Caption:= StrSourceVal + ' n/a';
      CurrentFiletimeAvail:=false;
    end else begin
      CurrentFiletime:=DateTime;
      CurrentFiletimeAvail:=true;
      Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime);
      SetInputFields(DateTime);
    end;
end;


{*
 * This saves the current timestamp. It is called...
 * - by File => Save date
 *}
procedure TForm1.SaveDateNow();
var DateTime:TDateTime;
    Attrs:integer;
begin
  if OpenedFile then begin

    if not Unprotect(CurrentFileName, Attrs) then begin
      if Config.OptWriteProtected then ShowMessage(ErrSaveWriteProtect)
      else ShowMessage(ErrSaveWriteProtect2);
    end;

    if (setFileDateTime(CurrentFileName, GetInputFields())) then begin
      // Display the current file time for verification.
      // TODO: Get the target time, not the source time!
      // However, we stay with the source time, as there may be multiple targets.
      getFileDateTime(CurrentFileName, DateTime);
      CurrentFiletime:=DateTime;
      CurrentFiletimeAvail:=true;
      Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime);
      Protect(CurrentFileName, Attrs);
    end else begin
      CurrentFiletimeAvail:=false;
      Label_CurrentFiletime.Caption := StrSourceVal + ' n/a';
      if (Config.OptTarget_EXIF_DateTime or Config.OptSource_EXIF_DateTimeOriginal or Config.OptSource_EXIF_DateTimeDigitized) then begin
        ShowMessage(ErrSaveWriteProtectEXIF);
      end else begin
        ShowMessage(ErrSaveWriteProtect3);
      end;
    end;

  end else if OpenedDir then begin

    if setDirDateTime(CurrentFileName, GetInputFields()) then begin
      // Display the current file time for verification.
      // TODO: Get the target time, not the source time!
      // However, we stay with the source time, as there may be multiple targets.
      if (getDirDateTime(CurrentFileName, DateTime)) then begin
        CurrentFiletime:=DateTime;
        CurrentFiletimeAvail := true;
        Label_CurrentFiletime.Caption := StrSourceVal + ' ' + FormatDateTime('dd.mm.yyyy hh:nn:ss', CurrentFiletime);
      end else begin
        //error
        CurrentFiletimeAvail := false;
        Label_CurrentFiletime.Caption := StrSourceVal + ' n/a';
      end;
    end else begin
      ShowMessage(ErrSaveDir);
    end;
    
  end else begin
    ShowMessage(ErrSaveNone);
  end;
end;



{*
 * Show checked options on main form (and update to/from config).
 * @param toConfig true stores options in Config unit, false retrieves them.
 }
procedure TForm1.ShowOptions(toConfig: Boolean = false);
var
  tmp: String;
  sumTargets: Integer;
begin
  ShowOptions_Semaphore.Acquire();

  try
    // make sure ShowOptions() is running only once
    if ShowOptions_isRunning then exit;
    ShowOptions_isRunning := true;

    if(toConfig) then begin
      Config.OptTime := CheckBox_Time.Checked;
      Config.OptDate := CheckBox_Date.Checked;
      Config.OptSource_EachTarget := OptSource_EachTarget.Checked;
      Config.OptSource_Created := OptSource_Created.Checked;
      Config.OptSource_Modified := OptSource_Modified.Checked;
      Config.OptSource_Access := OptSource_Access.Checked;
      Config.OptSource_EXIF_DateTime := OptSource_EXIF_DateTime.Checked;
      Config.OptSource_EXIF_DateTimeOriginal := OptSource_EXIF_DateTimeOriginal.Checked;
      Config.OptSource_EXIF_DateTimeDigitized := OptSource_EXIF_DateTimeDigitized.Checked;
      Config.OptTarget_Source := OptTarget_Source.Checked;
      Config.OptTarget_Created := OptTarget_Created.Checked;
      Config.OptTarget_Modified := OptTarget_Modified.Checked;
      Config.OptTarget_Access := OptTarget_Access.Checked;
      Config.OptTarget_EXIF_DateTime := OptTarget_EXIF_DateTime.Checked;
      Config.OptTarget_EXIF_DateTimeOriginal := OptTarget_EXIF_DateTimeOriginal.Checked;
      Config.OptTarget_EXIF_DateTimeDigitized := OptTarget_EXIF_DateTimeDigitized.Checked;
      Config.OptWriteProtected := OptWriteProtected.Checked;
      Config.OptSetDirCreateTime := OptSetDirCreateTime.Checked;
      if OptFtConversion_DEFAULT.Checked then begin
        Config.OptFtConversion := 'default';
        Config.CurrentFtConversion := Config.GetDefaultFtConversion();
      end;
      if OptFtConversion_FileTimeToLocalFileTime.Checked then begin
        Config.OptFtConversion := Config.StrOptFtConversion_FileTimeToLocalFileTime;
        Config.CurrentFtConversion := Config.StrOptFtConversion_FileTimeToLocalFileTime;
      end;
      if OptFtConversion_SystemTimeToTzSpecificLocalTime.Checked then begin
        Config.OptFtConversion := Config.StrOptFtConversion_SystemTimeToTzSpecificLocalTime;
        Config.CurrentFtConversion := Config.StrOptFtConversion_SystemTimeToTzSpecificLocalTime;
      end;
      Config.OptToolsSetDirTime := OptToolsSetDirTime.Checked;
      Config.OptFilesFirst := OptFilesFirst.Checked;
      Config.OptBreadthFirst := OptBreadthFirst.Checked;
      //Config.OptMainTime := OptMainTime.Checked; always set to (not OptOriginalTime)
      Config.OptOriginalTime := OptOriginalTime.Checked;
      if OptLang_DEFAULT.Checked then Config.OptLanguage := 'default';
      if OptLang_EN.Checked then Config.OptLanguage := 'en_US';
      if OptLang_DE.Checked then Config.OptLanguage := 'de_DE';
      Config.OptMainTime2 := OptMainTime2.Checked;
      Config.OptLatestSubdir := OptLatestSubdir.Checked;
    end else begin
      CheckBox_Time.Checked := Config.OptTime; // calls ShowOptions() indirectly
      CheckBox_Date.Checked := Config.OptDate; // calls ShowOptions() indirectly
      OptSource_EachTarget.Checked := Config.OptSource_EachTarget;
      OptSource_Created.Checked := Config.OptSource_Created;
      OptSource_Modified.Checked := Config.OptSource_Modified;
      OptSource_Access.Checked := Config.OptSource_Access;
      OptSource_EXIF_DateTime.Checked := Config.OptSource_EXIF_DateTime;
      OptSource_EXIF_DateTimeOriginal.Checked := Config.OptSource_EXIF_DateTimeOriginal;
      OptSource_EXIF_DateTimeDigitized.Checked := Config.OptSource_EXIF_DateTimeDigitized;
      OptTarget_Source.Checked := Config.OptTarget_Source;
      OptTarget_Created.Checked := Config.OptTarget_Created;
      OptTarget_Modified.Checked := Config.OptTarget_Modified;
      OptTarget_Access.Checked := Config.OptTarget_Access;
      OptTarget_EXIF_DateTime.Checked := Config.OptTarget_EXIF_DateTime;
      OptTarget_EXIF_DateTimeOriginal.Checked := Config.OptTarget_EXIF_DateTimeOriginal;
      OptTarget_EXIF_DateTimeDigitized.Checked := Config.OptTarget_EXIF_DateTimeDigitized;
      OptWriteProtected.Checked := Config.OptWriteProtected;
      OptSetDirCreateTime.Checked := Config.OptSetDirCreateTime;
      OptFtConversion_DEFAULT.Checked := (Config.OptFtConversion = 'default');
      OptFtConversion_DEFAULT.Caption := ReplaceString(MenuOptFtConversion_DEFAULT, '%default%', GetDefaultFtConversion());
      OptFtConversion_FileTimeToLocalFileTime.Checked := (Config.OptFtConversion = Config.StrOptFtConversion_FileTimeToLocalFileTime);
      OptFtConversion_SystemTimeToTzSpecificLocalTime.Checked := (Config.OptFtConversion = Config.StrOptFtConversion_SystemTimeToTzSpecificLocalTime);
      OptToolsSetDirTime.Checked := Config.OptToolsSetDirTime;
      OptFilesFirst.Checked := Config.OptFilesFirst;
      OptBreadthFirst.Checked := Config.OptBreadthFirst;
      OptMainTime.Checked := not Config.OptOriginalTime; // always set to (not Config.OptOriginalTime)
      OptOriginalTime.Checked := Config.OptOriginalTime;
      UpdateIncTime();
      OptMainTime2.Checked := Config.OptMainTime2;
      OptLatestSubdir.Checked := Config.OptLatestSubdir;
      //the following is already done in InitSettingsNow():
      //OptLang_DEFAULT := (Config.OptLanguage = 'default');
      //OptLang_EN := (Config.OptLanguage = 'en_US');
      //OptLang_DE := (Config.OptLanguage = 'de_DE');

      // However, changing the language also stores the settings,
      // thus we need to call the language switch here instead of InitSettingsNow();
      if OptLanguage = 'en_US' then OptLang_ENClick(nil);
      if OptLanguage = 'de_DE' then OptLang_DEClick(nil);
    end;

    if (Config.OptSource_Created) then begin
      ComboBox_Source.ItemIndex := 0;
    end else if (Config.OptSource_Modified) then begin
      ComboBox_Source.ItemIndex := 1;
    end else if (Config.OptSource_Access) then begin
      ComboBox_Source.ItemIndex := 2;
    end else if (Config.OptSource_EXIF_DateTime) then begin
      ComboBox_Source.ItemIndex := 3;
    end else if (Config.OptSource_EXIF_DateTimeOriginal) then begin
      ComboBox_Source.ItemIndex := 4;
    end else if (Config.OptSource_EXIF_DateTimeDigitized) then begin
      ComboBox_Source.ItemIndex := 5;
    end else if (Config.OptSource_EachTarget) then begin
      ComboBox_Source.ItemIndex := 6;
    end;

    sumTargets := 0;
    if (Config.OptTarget_Created) then sumTargets := sumTargets + 1;
    if (Config.OptTarget_Modified) then sumTargets := sumTargets + 1;
    if (Config.OptTarget_Access) then sumTargets := sumTargets + 1;
    if (Config.OptTarget_EXIF_DateTime) then sumTargets := sumTargets + 1;
    if (Config.OptTarget_EXIF_DateTimeOriginal) then sumTargets := sumTargets + 1;
    if (Config.OptTarget_EXIF_DateTimeDigitized) then sumTargets := sumTargets + 1;

    if (Config.OptTarget_Source) then begin
      ComboBox_Target.ItemIndex := 0;
    end else if (sumTargets = 1) then begin
      // Only one target selected
      if (Config.OptTarget_Created) then begin
        ComboBox_Target.ItemIndex := 1;
      end else if (Config.OptTarget_Modified) then begin
        ComboBox_Target.ItemIndex := 2;
      end else if (Config.OptTarget_Access) then begin
        ComboBox_Target.ItemIndex := 3;
      end else if (Config.OptTarget_EXIF_DateTime) then begin
        ComboBox_Target.ItemIndex := 4;
      end else if (Config.OptTarget_EXIF_DateTimeOriginal) then begin
        ComboBox_Target.ItemIndex := 5;
      end else if (Config.OptTarget_EXIF_DateTimeDigitized) then begin
        ComboBox_Target.ItemIndex := 6;
      end;
    end else begin
      // Various targets selected
      ComboBox_Target.ItemIndex := 7;
    end;

    if(OptMainTime.Checked) then begin
      OptMainTime.Caption:= MenuOptMainTime;
    end else begin
      OptMainTime.Caption:= MenuOptMainTime_Disabled;
    end;

    if(OptOriginalTime.Checked) then begin
      OptOriginalTime.Caption:= MenuOptOriginalTime;
    end else begin
      OptOriginalTime.Caption:= MenuOptOriginalTime_Disabled;
    end;

    if(
      (OptTarget_Created.Checked = True) and
      (OptTarget_Modified.Checked = True) and
      (OptTarget_Access.Checked = True) and
      (OptTarget_EXIF_DateTime.Checked = True) and
      (OptTarget_EXIF_DateTimeOriginal.Checked = True) and
      (OptTarget_EXIF_DateTimeDigitized.Checked = True)
    ) then begin
      OptTarget_SelectAll.Checked := True;
    end else begin
      OptTarget_SelectAll.Checked := False;
    end;

    if(
      OptSource_EXIF_DateTime.Checked or
      OptSource_EXIF_DateTimeOriginal.Checked or
      OptSource_EXIF_DateTimeDigitized.Checked
    ) then begin
      OptSource_EXIF.Checked := true;
    end else begin
      OptSource_EXIF.Checked := false;
    end;

    if(
      OptTarget_EXIF_DateTime.Checked or
      OptTarget_EXIF_DateTimeOriginal.Checked or
      OptTarget_EXIF_DateTimeDigitized.Checked
    ) then begin
      OptTarget_EXIF.Checked := true;
    end else begin
      OptTarget_EXIF.Checked := false;
    end;

    if OptTarget_Source.Checked then begin
      OptTarget_Created.Enabled := False;
      OptTarget_Modified.Enabled := False;
      OptTarget_Access.Enabled := False;
      OptTarget_EXIF.Enabled := False;
      OptTarget_SelectAll.Enabled := False;
    end else begin
      OptTarget_Created.Enabled := True;
      OptTarget_Modified.Enabled := True;
      OptTarget_Access.Enabled := True;
      OptTarget_EXIF.Enabled := True;
      OptTarget_SelectAll.Enabled := True;
    end;

    if OptSource_EachTarget.Checked then begin
      OptSource_Created.Enabled := False;
      OptSource_Modified.Enabled := False;
      OptSource_Access.Enabled := False;
      OptSource_EXIF.Enabled := False;
      OptTarget_Source.Enabled := False;
    end else begin
      OptSource_Created.Enabled := True;
      OptSource_Modified.Enabled := True;
      OptSource_Access.Enabled := True;
      OptSource_EXIF.Enabled := True;
      OptTarget_Source.Enabled := True;
    end;


    if OptOriginalTime.Checked then tmp := tmp + 'T';
    if OptIncreaseTime.Checked then tmp := tmp + 'I';

    if (tmp <> '') and (
    OptWriteProtected.Checked
    or OptSetDirCreateTime.Checked) then tmp := tmp + ' ';
    if OptWriteProtected.Checked then tmp := tmp + 'W';
    if OptSetDirCreateTime.Checked then tmp := tmp + 'C';

    if (tmp <> '') and (
    OptToolsSetDirTime.Checked
    or OptFilesFirst.Checked
    or OptBreadthFirst.Checked) then tmp := tmp + ' ';
    if OptToolsSetDirTime.Checked then tmp := tmp + 'D';
    if OptFilesFirst.Checked then tmp := tmp + 'F';
    if OptBreadthFirst.Checked then tmp := tmp + 'B';

    if (tmp <> '') and
    OptSaveSettings.Checked then tmp := tmp + ' ';
    if OptSaveSettings.Checked then tmp := tmp + 'Q';
    if tmp='' then begin
      Label_Options.Caption := StrOptionsNone;
    end else begin
      Label_Options.Caption := StrOptions + ' ' + tmp;
    end;

  finally
    ShowOptions_isRunning := false;
    ShowOptions_Semaphore.Release();
  end;

end;



{*
 * Show errors after processing multiple files and directories.
 }
procedure TForm1.ShowErrors(errs: MyErrors);
var
  err_string: String;
  tmp: String;
begin
  err_string:='';

  // First, we concatenate the error messages.

  case Form1.OptWriteProtected.checked of
    true: begin
      case errs.wprotected of
        0:;
        1: err_string:=err_string+' '+ErrRemoveProtection1;
      else err_string:=err_string+' '
        +ReplaceString(ErrRemoveProtectionN,'%n%',Stri(errs.wprotected));
      end;
    end;
    false: begin
      case errs.wprotected of
        0:;
        1: err_string:=err_string+' '+ErrProtected1;
      else err_string:=err_string+' '
        +ReplaceString(ErrProtectedN,'%n%',Stri(errs.wprotected));
      end;
    end;
  end;

  case errs.fileAccess of
    0:;
    1:err_string:=err_string+' '+ErrFileAccess1;

  else err_string:=err_string+' '
    +ReplaceString(ErrFileAccessN,'%n%',Stri(errs.fileAccess));
  end;

  case errs.dirAccess of
    0:;
    1:err_string:=err_string+' '+ErrDirAccess1;

  else err_string:=err_string+' '
    +ReplaceString(ErrDirAccessN,'%n%',Stri(errs.dirAccess));
  end;

  case errs.exifRead of
    0:;
    1:err_string:=err_string+' '+ErrNoExif1;

  else err_string:=err_string+' '
    +ReplaceString(ErrNoExifN,'%n%',Stri(errs.exifRead));
  end;

  // Finally, we prepend a summary.

  if err_string='' then begin
    tmp := MsgDirsFiles;
  end else begin
    tmp := ErrDirsFiles;
  end;

  case errs.files of
    1:tmp:=ReplaceString(tmp,'%files%',MsgFiles1);
    else tmp:=ReplaceString(tmp,'%files%',
      ReplaceString(MsgFilesN,'%n%',Stri(errs.files)) );
  end;
  case errs.dirs of
    1:tmp:=ReplaceString(tmp,'%dirs%',MsgDirs1);
    else tmp:=ReplaceString(tmp,'%dirs%',
      ReplaceString(MsgDirsN,'%n%',Stri(errs.dirs)) );
  end;
  tmp[1] := AnsiUpperCase(tmp[1])[1];
  err_string := tmp + err_string;

  ShowMessage(err_string);

end;



{*
 * called by FormCreate()
 }
procedure TForm1.InitSettingsNow();
var
  filename: String;
  Attrs: Integer;
begin
  filename := ExtractFilePath(Application.ExeName)+StrIniFile;
  CurrentSettings := TMemIniFile.Create(filename);
  LoadSettingsNow(filename, true);

  // If file exists and is not write protected,
  if FileExists(filename) then begin
    Attrs := FileGetAttr(filename);
    if (Attrs and faReadOnly = 0) then begin
      // save changes on exit (unless the ini file prohibits this by an option)
      OptSaveSettings.Checked := CurrentSettings.ReadBool(StrIniSection,'OptSaveSettings',true);
      // For your interest: The 'OptSaveSettings' value is NEVER saved by DDA
      // itself, i.e. you MUST add it manually to the DDA.ini file and set it to
      // false, in order to load its options and uncheck the 'save on exit' option.
    end;
  end;

  //if OptLanguage = 'en_US' then OptLang_ENClick(nil);
  //if OptLanguage = 'de_DE' then OptLang_DEClick(nil);

  // Finally, remove the key which prohibits the auto-save on exit
  // (so it won't mess up a manually saved config file).
  CurrentSettings.DeleteKey(StrIniSection,'OptSaveSettings');
end;

{*
 * get inc time from config
 }
procedure TForm1.UpdateIncTime();
begin
  with Config.CurrentIncTime do begin
    if (s=0) and (m=0) and (h=0) and (d=0) and (a=0) then begin
      OptIncreaseTime.checked:=false;
      OptIncreaseTime.Caption :=
        MenuOptIncreaseTime_Disabled+'...';
    end else begin
      OptIncreaseTime.checked:=true;
      OptIncreaseTime.Caption :=
        ReplaceString(MenuOptIncreaseTime, '%time%',
          IntToStr(a)+'a '
          + IntToStr(d)+'d '
          + IntToStr(h)+'h '
          + IntToStr(m)+'m '
          + IntToStr(s)+'s'
        )
        +'...';
    end;
  end;
end;





{*
 * Set file date using input params.
 * However, we cannot write output to the existing console,
 * as this is a GUI app and not a Console app.
 * TODO: Move this into DDA unit, or call it from there.
 }
procedure TForm1.setdate(datestr, filename: String);
var
  //sm_string: String;
  DateTime: TDateTime;
  gotDate: Boolean;
  isDirectory: Boolean;
  isFile: Boolean;
  code: Integer;
  hh,nn,ss,{ms,}dd,mm,yyyy:Word;
begin
  try
    //This is only needed to run as a "hidden" application:
    Application.ShowMainForm := false;
    Form1.Visible := false;


    gotDate := false;
    isDirectory := false;
    isFile := false;

    if DirectoryExists(filename) then begin
      isDirectory := true;
      gotDate := getDirDateTime(filename, DateTime);
    end else if FileExists(filename) then begin
      isFile := true;
      gotDate := getFileDateTime(filename, DateTime);
    end;

    if gotDate then begin
      // NB: Instead of ReplaceDate and ReplaceTime,
      // we maybe could also use Frac and Trunc here
      // (Frac returns time only, Trunc returns date only)
      case Length(datestr) of
        8: begin
          Val(copy(datestr,1,4),yyyy,code);
          Val(copy(datestr,5,2),mm,code);
          Val(copy(datestr,7,2),dd,code);
          ReplaceDate(DateTime,EncodeDate(yyyy,mm,dd));
        end;
        14: begin
          Val(copy(datestr,1,4),yyyy,code);
          Val(copy(datestr,5,2),mm,code);
          Val(copy(datestr,7,2),dd,code);
          Val(copy(datestr,9,2),hh,code);
          Val(copy(datestr,11,2),nn,code);
          Val(copy(datestr,13,2),ss,code);
          ReplaceDate(DateTime,EncodeDate(yyyy,mm,dd));
          ReplaceTime(DateTime,EncodeTime(hh,nn,ss,0));
        end;
        6: begin
          Val(copy(datestr,1,2),hh,code);
          Val(copy(datestr,3,2),nn,code);
          Val(copy(datestr,5,2),ss,code);
          ReplaceTime(DateTime,EncodeTime(hh,nn,ss,0));
        end;
      else
      end;

      //AllocConsole();
      if isDirectory then begin
        if setDirDateTime(filename, DateTime) then begin
          //Writeln('Okay.');
        end else begin
          //Writeln('Error setting directory date.');
        end;
      end else if isFile then begin
        if setFileDateTime(filename, DateTime) then begin
          //Writeln('Okay.');
        end else begin
          //Writeln('Error setting file date.');
        end;
      end;
      //Readln;
      //FreeConsole();
    end else begin
      //AllocConsole();
      //Writeln('Error: Cannot open file or directory. Use /? to show options.');
      //Readln;
      //FreeConsole();
    end;
  finally
    Application.Terminate;
    //Halt(0);
  end;
end;


{*
 * toggle "Change time"
 }
procedure TForm1.CheckBox_TimeClick(Sender: TObject);
begin
  DateTimePicker_Time.Enabled := CheckBox_Time.Checked;
  ShowOptions(true);
end;

{*
 * toggle "Change date"
 }
procedure TForm1.CheckBox_DateClick(Sender: TObject);
begin
  DateTimePicker_Date.Enabled := CheckBox_Date.Checked;
  ShowOptions(true);
end;


{*
 * "Now" button (time).
 }
procedure TForm1.Button_TimeNowClick(Sender: TObject);
begin
  DateTimePicker_Time.DateTime := Now;
end;

{*
 * "Today" button (date).
 }
procedure TForm1.Button_DayTodayClick(Sender: TObject);
begin
  DateTimePicker_Date.DateTime := Now;
end;

{*
 * Source date combobox.
 }
procedure TForm1.ComboBox_SourceChange(Sender: TObject);
var i: Integer;
begin
  if (Config.OptSource_EachTarget and
   (ComboBox_Source.ItemIndex <> -1) and
   (ComboBox_Source.ItemIndex <> 6)
   ) then begin
    i := ComboBox_Source.ItemIndex;
    OptSource_EachTarget.Click;
    ComboBox_Source.ItemIndex := i;
  end;

  if (ComboBox_Source.ItemIndex = 0) then begin
    // Created
    if (not Config.OptSource_Created) then
     OptSource_Created.Click;
  end else if (ComboBox_Source.ItemIndex = 1) then begin
    // Modified
    if (not Config.OptSource_Modified) then
     OptSource_Modified.Click;
  end else if (ComboBox_Source.ItemIndex = 2) then begin
    // Last access
    if (not Config.OptSource_Access) then
     OptSource_Access.Click;
  end else if (ComboBox_Source.ItemIndex = 3) then begin
    // EXIF Date Time
    if (not Config.OptSource_EXIF_DateTime) then
     OptSource_EXIF_DateTime.Click;
  end else if (ComboBox_Source.ItemIndex = 4) then begin
    // EXIF Date Time Original
    if (not Config.OptSource_EXIF_DateTimeOriginal) then
     OptSource_EXIF_DateTimeOriginal.Click;
  end else if (ComboBox_Source.ItemIndex = 5) then begin
    // EXIF Date Time Digitized
    if (not Config.OptSource_EXIF_DateTimeDigitized) then
     OptSource_EXIF_DateTimeDigitized.Click;
  end else if (ComboBox_Source.ItemIndex = 6) then begin
    // each selected target date
    if (not Config.OptSource_EachTarget) then
     OptSource_EachTarget.Click;
  end;
end;

{*
 * "Save" button.
 }
procedure TForm1.Button_SaveDateClick(Sender: TObject);
begin
  SaveDate.Click;
end;

{*
 * "Refresh" button.
 }
procedure TForm1.Button_RefreshClick(Sender: TObject);
begin
  //ShowOptions(true);
  if OpenedFile then OpenFileDateNow(CurrentFileName);
  if OpenedDir then OpenDirDateNow(CurrentFileName);
end;

{*
 * Target date combobox.
 }
procedure TForm1.ComboBox_TargetChange(Sender: TObject);
begin
  if (ComboBox_Target.ItemIndex = 0) then begin
    // same as source date
    // TODO
    if (Config.OptSource_EachTarget) then begin
      //ComboBox_Target.ItemIndex := 1;
      ShowOptions(true);
    end else if (not Config.OptTarget_Source) then
     OptTarget_Source.Click;
  end else if (ComboBox_Target.ItemIndex = 1) then begin
    // created
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := true;
    OptTarget_Modified.Checked := false;
    OptTarget_Access.Checked := false;
    OptTarget_EXIF_DateTime.Checked := false;
    OptTarget_EXIF_DateTimeOriginal.Checked := false;
    OptTarget_EXIF_DateTimeDigitized.Checked := false;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 2) then begin
    // modified
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := false;
    OptTarget_Modified.Checked := true;
    OptTarget_Access.Checked := false;
    OptTarget_EXIF_DateTime.Checked := false;
    OptTarget_EXIF_DateTimeOriginal.Checked := false;
    OptTarget_EXIF_DateTimeDigitized.Checked := false;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 3) then begin
    // access
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := false;
    OptTarget_Modified.Checked := false;
    OptTarget_Access.Checked := true;
    OptTarget_EXIF_DateTime.Checked := false;
    OptTarget_EXIF_DateTimeOriginal.Checked := false;
    OptTarget_EXIF_DateTimeDigitized.Checked := false;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 4) then begin
    // EXIF DateTime
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := false;
    OptTarget_Modified.Checked := false;
    OptTarget_Access.Checked := false;
    OptTarget_EXIF_DateTime.Checked := true;
    OptTarget_EXIF_DateTimeOriginal.Checked := false;
    OptTarget_EXIF_DateTimeDigitized.Checked := false;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 5) then begin
    // EXIF DateTimeOriginal
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := false;
    OptTarget_Modified.Checked := false;
    OptTarget_Access.Checked := false;
    OptTarget_EXIF_DateTime.Checked := false;
    OptTarget_EXIF_DateTimeOriginal.Checked := true;
    OptTarget_EXIF_DateTimeDigitized.Checked := false;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 6) then begin
    // EXIF DateTimeDigitized
    OptTarget_Source.Checked := false;
    OptTarget_Created.Checked := false;
    OptTarget_Modified.Checked := false;
    OptTarget_Access.Checked := false;
    OptTarget_EXIF_DateTime.Checked := false;
    OptTarget_EXIF_DateTimeOriginal.Checked := false;
    OptTarget_EXIF_DateTimeDigitized.Checked := true;
    ShowOptions(true);
  end else if (ComboBox_Target.ItemIndex = 7) then begin
    // various (see options menu)
    if (Config.OptTarget_Source) then begin
     OptTarget_Source.Click;
    end else begin
      ShowOptions(true);
    end;
  end;
end;

{*
 * Cancel button.
 }
procedure TForm1.Button_CancelClick(Sender: TObject);
begin
  OpenedFile:=false;
  OpenedDir:=false;
  Memo_Filename.Text:=StrNoFile;
  Label_CurrentFiletime.Caption:= '';
  Button_SaveDate.Enabled := false;
  SaveDate.Enabled := false;
  Button_Refresh.Enabled := false;
  Button_Cancel.Enabled := false;
end;

procedure TForm1.Button_LoadFileClick(Sender: TObject);
begin
  OpenFileDate.Click;
end;






end.

