unit Unit3;

// This project is documented using the Doxygen documentation system.
// http://www.doxygen.org
// http://pas2dox.sourceforge.net

{* @file Unit3.pas
 * @brief The "increase time" form's unit (TForm3).
}

{* @class TForm3
 * @brief The "increase time" form.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm3 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Button2: TButton;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit5: TEdit;
    GroupBox1: TGroupBox;
    DateTimePicker_Date: TDateTimePicker;
    DateTimePicker_Time: TDateTimePicker;
    DateTimePicker2_Date: TDateTimePicker;
    DateTimePicker2_Time: TDateTimePicker;
    Button3: TButton;
    Label6: TLabel;
    Label7: TLabel;
    procedure ResetInput();
    procedure ValidateInput();
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form3: TForm3;
  //number: Integer;


implementation

uses Unit1, Config, gnugettext;

{$R *.dfm}

// Close without changing values:
procedure TForm3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // do nothing
end;

// Validate String number (remove non-number chars).
function NumStri(var arg: String): Integer;
var
  code, number:Integer;
begin
  VAL(arg, number, code);
  Str(number, arg);
  IF number=0 then arg:='0';
  Result := number;
end;

// Reset input.
procedure TForm3.ResetInput();
begin
  Edit1.Text := '';
  Edit2.Text := '';
  Edit3.Text := '';
  Edit4.Text := '';
  Edit5.Text := '';
end;

{
procedure TForm3.Edit1Change(Sender: TObject);
var strvalue:String;
begin
  strvalue:=Form3.Edit1.Text;
  NumStri(strvalue);
  Form3.Edit1.Text:=strvalue;
  //86400sec = 1d
  If (number>86400) then Form3.Edit1.Text:='86400';
end;
}

{*
 * Validate the input values and store the result in Config.
 }
procedure TForm3.ValidateInput();
var sec, min, hrs, ds, yrs: Integer;
    strvalue:String;
begin
  sec:=0;
  min:=0;
  hrs:=0;
  ds:=0;
  yrs:=0;

  strvalue:=Form3.Edit1.Text;
  NumStri(strvalue);
  sec:=StrToInt(strvalue);
  min:=sec div 60;
  sec:=sec mod 60;

  strvalue:=Form3.Edit2.Text;
  NumStri(strvalue);
  min:=min+StrToInt(strvalue);
  hrs:=min div 60;
  min:=min mod 60;

  strvalue:=Form3.Edit3.Text;
  NumStri(strvalue);
  hrs:=hrs+StrToInt(strvalue);
  ds:=hrs div 24;
  hrs:=hrs mod 24;

  strvalue:=Form3.Edit4.Text;
  NumStri(strvalue);
  ds:=ds+StrToInt(strvalue);

  strvalue:=Form3.Edit5.Text;
  NumStri(strvalue);
  yrs:=StrToInt(strvalue);

  Form3.Edit1.Text:=IntToStr(sec);
  Form3.Edit2.Text:=IntToStr(min);
  Form3.Edit3.Text:=IntToStr(hrs);
  Form3.Edit4.Text:=IntToStr(ds);
  Form3.Edit5.Text:=IntToStr(yrs);

  Config.SetIncTime(sec, min, hrs, ds, yrs);
end;


procedure TForm3.Button1Click(Sender: TObject);
begin
  ValidateInput();
  Form3.Close();
end;

procedure TForm3.Button2Click(Sender: TObject);
begin
  ResetInput();
end;

procedure TForm3.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  Msg: TMsg;
begin
  if (Key = VK_Escape) then begin
    PeekMessage(Msg, 0, WM_CHAR, WM_CHAR, PM_REMOVE); // No BEEP.
    Close;
  end;
end;

procedure TForm3.FormShow(Sender: TObject);
begin
  Edit1.Text := IntToStr(Config.CurrentIncTime.s);
  Edit2.Text := IntToStr(Config.CurrentIncTime.m);
  Edit3.Text := IntToStr(Config.CurrentIncTime.h);
  Edit4.Text := IntToStr(Config.CurrentIncTime.d);
  Edit5.Text := IntToStr(Config.CurrentIncTime.a);
end;


procedure TForm3.FormCreate(Sender: TObject);
begin
  TranslateComponent(self); //gnugettext
  DateTimePicker_Date.DateTime := Now;
  DateTimePicker_Time.DateTime := Now;
  DateTimePicker2_Date.DateTime := Now;
  DateTimePicker2_Time.DateTime := Now;
end;

procedure TForm3.Button3Click(Sender: TObject);
var
  actualDT, targetDT, differenceDT: TDateTime;
  Hour, Min, Sec, MSec: Word;
  factor: Integer;

begin
// Calculate difference
  actualDT := Frac(DateTimePicker_Time.DateTime) + Trunc(DateTimePicker_Date.DateTime);
  targetDT := Frac(DateTimePicker2_Time.DateTime) + Trunc(DateTimePicker2_Date.DateTime);
  differenceDT := targetDT - actualDT;
  if(differenceDT < 0) then begin
    factor := -1;
  end else begin
    factor := 1;
  end;

  DecodeTime(Frac(differenceDT), Hour, Min, Sec, MSec);

  Edit1.Text := IntToStr(factor * Sec);
  Edit2.Text := IntToStr(factor * Min);
  Edit3.Text := IntToStr(factor * Hour);
  Edit4.Text := IntToStr(Trunc(differenceDT));
  Edit5.Text := '0';
end;

end.
