unit Unit4;

// This project is documented using the Doxygen documentation system.
// http://www.doxygen.org
// http://pas2dox.sourceforge.net

{* @file Unit4.pas
 * @brief The "progress" form's unit (TForm4).
}

{* @class TForm4
 * @brief The "progress" form.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm4 = class(TForm)
    Button1: TButton;
    Animate1: TAnimate;
    ProgressBar1: TProgressBar;
    Timer1: TTimer;
    Label_numFiles: TLabel;
    Label_curFile: TLabel;
    Label_memUsed: TLabel;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormRetranslate();
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure setMarquee(marquee: Boolean);
    procedure Finish();
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    //actionCancelled: boolean;
    numFiles: integer;
    //curFile: String;
  end;

var
  Form4: TForm4;
  dtStarted: TDateTime;
  finished: Boolean;
  origTitle: String;

implementation

uses Unit1, Config, gnugettext, Helpers;

{$R *.dfm}

{*
 * Initialize the progress form on creation.
 }
procedure TForm4.FormCreate(Sender: TObject);
begin
  //AlphaBlend := true;
  //AlphaBlendValue := 230;
  TranslateComponent(self); //gnugettext
  // TODO Test animation in Windows 7 and Windows 10.
  Animate1.ResName := 'PROGRESS2';
  Animate1.Active := False;
  origTitle := Application.Title;
  Form4.DoubleBuffered := True;
  ProgressBar1.DoubleBuffered := True;
end;

procedure TForm4.FormRetranslate();
begin
  //RetranslateComponent(Form4.Caption);
  //RetranslateComponent(self);
  Form4.Caption := StrProgressCaption;
  if (finished) then begin
    Button1.Caption := Config.StrClose;
  end else begin
    Button1.Caption := Config.StrCancel;
  end;
end;

{*
 * Reinitialize and display the progress form.
 }
procedure TForm4.FormShow(Sender: TObject);
begin
  finished := false;
  Application.Title := origTitle + ':';
  Animate1.StartFrame := 1;
  Animate1.StopFrame := 4;
  Animate1.Active := True;
  ProgressBar1.Position := 0;
  Timer1.Enabled := True;
  setMarquee(true);
  Button1.Enabled := True;
  Config.curProcCancelled := False;
  numFiles := 0;
  Config.curProcFile := '';
  Label_numFiles.Caption := '';
  Label_curFile.Caption := '';
  Label_memUsed.Caption := '';
  dtStarted := Now;
  Memo1.Clear;
  Memo1.Lines.Add(DateTimeToStr(dtStarted) + ' - ' + MsgProcStarted);
  Button1.Caption := Config.StrCancel;
end;

{*
 * Cancel/Close button.
 }
procedure TForm4.Button1Click(Sender: TObject);
begin
  if (finished) then begin
    Memo1.Clear;
    Close;
    // Note: If the process did just finish,
    // a message window appears, informing the user,
    // so he/she cannot close this form accidentally.
  end else begin
    Timer1.Enabled := false;
    setMarquee(false);
    Timer1Timer(Sender);
    if (
      MessageDlg(Config.StrReallyCancel, mtWarning, [mbYes, mbNo], 0) = mrYes
    ) then begin
      //Close;
      //Button1.Enabled := False;
      Config.curProcCancelled := True;
    end;
    Timer1.Enabled := true;
    setMarquee(true);
  end;
end;

{*
 * On form close, disable animations.
 * (This is needed, as otherwise the animations will not start immediately
 *  on FormShow.)
 }
procedure TForm4.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Application.Title := origTitle;
  Animate1.StartFrame := 1;
  Animate1.StopFrame := 1;
  Animate1.Active := False;
  Timer1.Enabled := False;
  setMarquee(false);
end;

{*
 * On finish, disable animations.
 }
procedure TForm4.Finish();
begin
  Animate1.StartFrame := 1;
  Animate1.StopFrame := 1;
  Animate1.Active := False;
  Timer1.Enabled := False;
  setMarquee(false);
  if (Config.curProcCancelled) then begin
    Memo1.Lines.Add(DateTimeToStr(Now) + ' - ' + MsgProcCancelled);
  end else begin
    Memo1.Lines.Add(DateTimeToStr(Now) + ' - ' + MsgProcFinished);
    Config.curProcFile := MsgProcFinished;
  end;
  Timer1Timer(nil);
  Application.Title := origTitle;
  Button1.Caption := Config.StrClose;
  ProgressBar1.Position := 100;
  finished := true;
end;

{*
 * Update display on each timer event (i.e. each 125 ms).
 }
procedure TForm4.Timer1Timer(Sender: TObject);
var
  mem: integer;
  hs: THeapStatus;
  dtDifference: TDateTime;
  Hour, Min, Sec, MSec: Word;
  formattedTime: String;
  formattedMem: String;
begin
  if (ProgressBar1.Position <= 97) then begin
    ProgressBar1.Position := ProgressBar1.Position + 3;
  end else begin
    ProgressBar1.Position := 0;
  end;
  Label_numFiles.Caption := ReplaceString(
    ReplaceString(MsgDirsFilesProc, '%n%', FloatToStrF(Config.curProcErrors.files,ffNumber,10,0)),
    '%m%', FloatToStrF(Config.curProcErrors.dirs,ffNumber,10,0)
  );
  Label_curFile.Caption := Config.curProcFile;
  hs := GetHeapStatus;
  mem := hs.TotalAllocated + hs.Overhead;
  if (mem < 1024*1024*10) then begin
    formattedMem := FloatToStrF(mem/1024,ffNumber,10,1) + ' kB';
  end else begin
    formattedMem := FloatToStrF(mem/(1024*1024),ffNumber,10,2) + ' MB';
  end;

  dtDifference := Now - dtStarted;
  DecodeTime(Frac(dtDifference), Hour, Min, Sec, MSec);
  DateTimeToString(formattedTime, 'tt', dtDifference);
  if (dtDifference >= 1) then begin
    formattedTime := IntToStr(Trunc(dtDifference)) + 'd ' + formattedTime;
  end;

  Label_memUsed.Caption := ReplaceString(MsgTimeElapsed, '%s%', formattedTime)
  + '   ' + ReplaceString(MsgMemUsage, '%s%', formattedMem);

  Application.Title := origTitle + ': ' + formattedTime;
end;

{*
 * Enable/disable marquee style for progress bar.
 * @param marquee true to enable, false to disable.
 }
procedure TForm4.setMarquee(marquee: Boolean);
var
  cs: LongInt;
const
  PBS_MARQUEE = $08;
  PBM_SETMARQUEE = WM_USER + 10;
begin
  cs := GetWindowLong(ProgressBar1.Handle, GWL_STYLE);
  if(marquee) then begin
    SetWindowLong(ProgressBar1.Handle, GWL_STYLE, cs or PBS_MARQUEE);
  end else begin
    SetWindowLong(ProgressBar1.Handle, GWL_STYLE, cs and not PBS_MARQUEE);
  end;
  SendMessage(ProgressBar1.Handle, PBM_SETMARQUEE, 1, 40);
end;

procedure TForm4.FormResize(Sender: TObject);
begin
  with Button1 do begin
    Left := (Parent.Width - Width) div 2;
  end;
end;

end.
