{
 TETRIS clone coded by Manuel Haim, February 2003
 Ported from Delphi(Win32) to Pascal(DOS)
 v0.8 of March 2004, released as OPEN SOURCE software

 Source to be successfully compiled with Borland Turbo Pascal v6.0
 Visit http://McSquirrel.istcool.de
}
program McTris;
uses Crt, Dos;

type
  TMyHighscore = record
    Name: string;
    Score: longint;
  end;
  TMyStone = array [1..4, 1..4] of byte;
  TMyPlayground = array [1..23, 1..10] of byte;
var
    waitforfall: boolean;
    X, Y, x1, y1: Integer;
    Playground: TMyPlayground;
    Score: longint; {has maximum 2.147.483.647 instead of 32.767}
    px, py: integer;
    DrawX, DrawY: Integer;
    ThisStone: TMyStone; {=
//     ((0,0,0,0),
//      (0,0,0,0),
//      (0,0,0,0),
//      (0,0,0,0));}
    NextStone: TMyStone;{// =
//     ((0,0,0,0),
//      (0,0,0,0),
//      (0,0,0,0),
//      (0,0,0,0));}

  Highscore: array[1..20] of TMyHighscore;
  MyStones: array[1..7] of TMyStone;
  GameQuit: boolean;
  Ch: char;
  TimeH1, TimeM1, TimeS1, TimeHu1: word;
  TimeH2, TimeM2, TimeS2, TimeHu2: word;
  TimerInterval: integer; {delay in 1/100 sec}
  z01: integer;
  ch1: char;
  LastWinner: integer;

procedure LoadHighscore;
var f1: text;
    z1, z2, z3: integer;
    s1, s2: string;
    l1: longint;
begin
  for z1 := 1 to 20 do begin
    Highscore[z1].Name := '';
    Highscore[z1].Score := 0;
  end;
  {try}
    Assign(f1, 'highscor.dat');
    {$I-}
    reset(f1);
    {$I+}
    if ioresult=0 then begin
      z1 := 0;
      while not eof(f1) do begin
        readln(f1, s1);
        z1 := z1 + 1;
        if z1 <= 20 then begin
          Highscore[z1].Name := copy(s1, 1, Pos(';', s1) - 1);
          Delete(s1, 1, Pos(';', s1));
          if length(s1) > 9 then s1 := copy(s1, 1, 9);
          while length(s1) < 9 do begin
            s1 := '0' + s1;
          end;
          Highscore[z1].Score := 0;
          Val(copy(s1, 1, 3),z2, z3);
          l1 := z2;
          Highscore[z1].Score := 1000*1000*l1;
          Val(copy(s1, 4, 3),z2, z3);
          l1 := z2;
          Highscore[z1].Score := Highscore[z1].Score + 1000*l1;
          Val(copy(s1, 7, 3),z2, z3);
          Highscore[z1].Score := Highscore[z1].Score +z2;
        end;
      end;
    end else begin
      {//showmessage('File error:' +#13#10}
      {// + 'The file couldn't be loaded.');}
    end;
  {finally}
    {$I-}
    close(f1);
    {$I+}
    if ioresult=0 then begin end; {//Reset ioresult}
  {end;}
end;


procedure AddHighscore;
var z1, z2: integer;
    b1: boolean;
    Ch: char;
    s1: string;
begin
  if Highscore[20].Score > Score then exit;

  GotoXY(5+DrawX,8+DrawY);
  Write('Yourname?Ŀ');
  GotoXY(5+DrawX,9+DrawY);
  Write('            ');
  TextColor(7);
  GotoXY(5+DrawX,10+DrawY);
  Write('');
  GotoXY(5+DrawX+2,9+DrawY);
  repeat until keypressed;

  b1 := false;
  s1 := '';

  while not b1 do begin
    ch := readkey;
    if  ch = #0 then begin
      {nothing}
    end else begin
      if Ord(ch) = 8 then Delete(s1, Length(s1), 1);
      if Ord(ch) = 13 then b1 := true;
      if Pos(ch,
       'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 ')
       <> 0 then begin
        if Length(s1) < 10 then s1 := s1 + ch;
      end;
    end;
    GotoXY(5+DrawX+2,9+DrawY);
    Write('          ');
    GotoXY(5+DrawX+2,9+DrawY);
    Write(s1);
  end;
  clrscr;


  z1 := 0;
  b1 := false;
  while not b1 do begin
  {for z1 := 1 to 20}
    z1 := z1 + 1;
    if Highscore[z1].Score <= Score then begin
      for z2 := 19 downto z1 do begin
        Highscore[z2 + 1].Name := Highscore[z2].Name;
        Highscore[z2 + 1].Score := Highscore[z2].Score;
      end;
      Highscore[z1].Name := s1;
      Highscore[z1].Score := Score;
      LastWinner := z1;
      b1 := true; {break}
    end;
    if z1 = 20 then b1 := true;
  end;
end;


procedure SaveHighscore;
var f1: text;
    z1, z2, z3, z4: integer;
    s1, s2: string;
begin
  {try}
    Assign(f1, 'highscor.dat');
    {$I-}
    Rewrite(f1);
    {$I+}
    if ioresult=0 then begin
      for z1 := 1 to 20 do begin
        s1 := '';
        s2 := '';
        z2 := Trunc(Highscore[z1].Score / (1000*1000));
        Str(z2, s2);
        while length(s2) < 3 do begin
          s2 := '0' + s2;
        end;
        s1 := s1 + s2;
        z4 := z2;
        z2 := Trunc(Trunc(Highscore[z1].Score / (1000)) - 1000*z4);
        while length(s2) < 3 do begin
          s2 := '0' + s2;
        end;
        Str(z2, s2);
        s1 := s1 + s2;
        z3 := z2;
        z2 := Trunc(Trunc(Highscore[z1].Score / (1)) - 1000*z4 - 1000*z3);
        Str(z2, s2);
        while length(s2) < 3 do begin
          s2 := '0' + s2;
        end;
        s1 := s1 + s2;
        while copy(s1, 1, 1) = '0' do begin
          Delete(s1, 1, 1);
        end;
        s1 := Highscore[z1].Name + ';' + s1;
        WriteLn(f1, s1);
      end;
    end else begin
      {//showmessage('File error:' +#13#10}
      {// + 'The file couldn't be written.');}
    end;
  {finally}
    {$I-}
    close(f1);
    {$I+}
    if ioresult=0 then begin end; {//Reset ioresult}
  {end;}
end;



procedure DrawField;
var s1: string;
begin
  for y := 1 to 23 do begin
    GotoXY(1+DrawX,y+DrawY);
    write('');
    GotoXY(22+DrawX,y+DrawY);
    write('');
    for x := 1 to 10 do begin
      GotoXY(2*x+DrawX,y+DrawY);
      str(Playground[y,x], s1);
      Case Playground[y, x] of
        0: s1 := ' ';
        1: s1 := '';
        2: s1 := '';
        3: s1 := '';
        4: s1 := '';
        5: s1 := '';
        6: s1 := '';
        7: s1 := '';
      end;
      TextColor(7);
      s1 := '';
      Case Playground[y, x] of
        0: TextColor(0);
        1: TextColor(7);
        2: TextColor(9);
        3: TextColor(12);
        4: TextColor(5);
        5: TextColor(10);
        6: TextColor(14);
        7: TextColor(11);
      end;
      write(s1+s1);
      TextColor(7);
    end;
  end;
  GotoXY(1+DrawX,24+DrawY);
  write('');
  for x := 2 to 21 do begin
    GotoXY(x+DrawX,24+DrawY);
    write('');
  end;
  GotoXY(22+DrawX,24+DrawY);
  write('');
end;

procedure DrawStone;
var s1: string;
begin
  for y := 1 to 4 do begin
    for x := 1 to 4 do begin
      if ThisStone[y, x] <> 0 then begin
      GotoXY(2*(x+px)+DrawX,y+py+DrawY);
      str(ThisStone[y, x], s1);
      Case ThisStone[y, x] of
        0: s1 := ' ';
        1: s1 := '';
        2: s1 := '';
        3: s1 := '';
        4: s1 := '';
        5: s1 := '';
        6: s1 := '';
        7: s1 := '';
      end;
      TextColor(7);
      s1 := '';
      Case ThisStone[y, x] of
        0: TextColor(0);
        1: TextColor(7);
        2: TextColor(9);
        3: TextColor(12);
        4: TextColor(5);
        5: TextColor(10);
        6: TextColor(14);
        7: TextColor(11);
      end;
      write(s1+s1);
      TextColor(7);
      end;
    end;
  end;
end;


procedure DisplayIt;
begin
end;

procedure ShowNext;
var s1: string;
begin
  for y := 1 to 4 do begin
    for x := 1 to 4 do begin
      GotoXY(x*2+23+DrawX,y+DrawY);
      str(NextStone[y, x], s1);
      Case NextStone[y, x] of
        0: s1 := ' ';
        1: s1 := '';
        2: s1 := '';
        3: s1 := '';
        4: s1 := '';
        5: s1 := '';
        6: s1 := '';
        7: s1 := '';
      end;
      TextColor(7);
      s1 := '';
      Case NextStone[y, x] of
        0: TextColor(0);
        1: TextColor(7);
        2: TextColor(9);
        3: TextColor(12);
        4: TextColor(5);
        5: TextColor(10);
        6: TextColor(14);
        7: TextColor(11);
      end;
      write(s1+s1);
      TextColor(7);
    end;
  end;
  GotoXY(25+DrawX,6+DrawY);
  str(Score, s1);
  write(s1);
end;

function StoneValid(Stone: TMyStone; x1, y1: integer): boolean;
var x, y: integer;
    b1: boolean;
begin
  b1 := true;
  for y := (y1 + 1) to (y1 + 4) do begin
    for x := (x1 + 1) to (x1 + 4) do begin
      if (x >= 1) and (x <= 10) and (y >= 1) and (y <= 23) then begin
        {if one part of the stone would overlap another existing stone:}
        if ThisStone[y - y1, x - x1] <> 0 then begin
          if Playground[y, x] <> 0 then b1 := false;
        end;
      end else begin
        if ThisStone[y - y1, x - x1] <> 0 then b1 := false;
      end;
    end;
  end;
  StoneValid := b1;
  {if b1 then write('valid') else write('non-valid');}
end;

procedure StoneMove(x1, y1: integer);
var b1, b2: boolean;
    x, y, z1, z2: integer;
begin

  if x1 = 1 then begin
    if StoneValid(ThisStone, px + 1, py) then begin
      px := px + 1;
      DrawField;
      DrawStone;
      DisplayIt;
    end;
  end;
  if x1 = -1 then begin
    if StoneValid(ThisStone, px - 1, py) then begin
      px := px - 1;
      DrawField;
      DrawStone;
      DisplayIt;
    end;
  end;
  if y1 = 1 then begin
    if StoneValid(ThisStone, px, py + 1) then begin
      {move stone one step down:}
      py := py + 1;
      DrawField;
      DrawStone;
      DisplayIt;
    end else begin
      {put stone:}
      for y := (py + 1) to (py + 4) do begin
        for x := (px + 1) to (px + 4) do begin
          if ThisStone[y - py, x - px] <> 0 then
            Playground[y, x] := ThisStone[y - py, x - px];
        end;
      end;
      {clear completed lines:}
      z2 := 0;
      for y := 1 to 23 do begin
        b2 := true;
        for x := 1 to 10 do begin
          if Playground[y, x] = 0 then b2 := false;
        end;
        if b2 then begin
          for x := 1 to 10 do begin
            Playground[y, x] := 0;
          end;
          z2 := z2 + 1;
          DrawField;
          DrawStone;
          DisplayIt;
          for z1 := y downto 2 do begin
            for x := 1 to 10 do begin
              Playground[z1, x] := Playground[z1 - 1, x];
            end;
          end;
          for x := 1 to 10 do begin
            Playground[1, x] := 0;
          end;
          DrawField;
          DrawStone;
          DisplayIt;
        end;
      end;
      {add points to score:}
      Case z2 of
        1: Score := Score + 100;
        2: Score := Score + 200;
        3: Score := Score + 400;
        4: Score := Score + 800;
      end;
      {insert a new stone:}
      {Randomize;}
      ThisStone := NextStone;
      if not StoneValid(ThisStone, 4, 0) then begin
        ShowNext;
        GotoXY(5+DrawX,8+DrawY);
        Write('Ŀ');
        GotoXY(5+DrawX,9+DrawY);
        Write(' Game over! ');
        TextColor(12+Blink);
        GotoXY(5+DrawX+2,9+DrawY);
        Write('Game over!');
        TextColor(7);
        GotoXY(5+DrawX,10+DrawY);
        Write('');

        repeat until keypressed;
        repeat
          Ch := ReadKey;
        until ((not(Ch = #0)) and ((ord(Ch) = 13)) or (ord(Ch) = 27));

        GameQuit := true;
        Exit;
      end else begin
        Score := Score + 10;
        NextStone := MyStones[Trunc(Random * 7) + 1];
        ShowNext;
        py := 0;
        px := 4;
        DrawField;
        DrawStone;
        DisplayIt;
      end;
    end;
  end;

end;

procedure StoneFall;
begin
end;

procedure StoneRotate;
var tempStone: TMyStone;
    x, y, z1, v_px, v_py: integer;
    b1: boolean;
label towardsCenter;
begin
  v_px := px;
  v_py := py;
  for y := 1 to 4 do begin
    for x := 1 to 4 do begin
      tempStone[y, x] := ThisStone[5-x, y];
    end;
  end;
  {align-to-top:}
  for z1 := 1 to 3 do begin
    b1 := true;
    for x := 1 to 4 do begin
      if tempStone[1,x] <> 0 then b1 := false;
    end;
    if b1 then begin
      for y := 2 to 4 do begin
        for x := 1 to 4 do begin
          tempStone[y - 1, x] := tempStone[y, x];
        end;
      end;
      for x := 1 to 4 do begin
        tempStone[4, x] := 0;
      end;
    end;
  end;
  {align-to-left:}
  for z1 := 1 to 3 do begin
    b1 := true;
    for y := 1 to 4 do begin
      if tempStone[y,1] <> 0 then b1 := false;
    end;
    if b1 then begin
      for y := 1 to 4 do begin
        for x := 2 to 4 do begin
          tempStone[y, x - 1] := tempStone[y, x];
        end;
      end;
      for y := 1 to 4 do begin
        tempStone[y, 4] := 0;
      end;
    end;
  end;
  {test now, if tempStone is suitable}

  towardsCenter:
  b1 := true;
  for y := (v_py + 1) to (v_py + 4) do begin
    for x := (v_px + 1) to (v_px + 4) do begin
      if (x >= 1) and (x <= 10) and (y >= 1) and (y <= 23) then begin
        {//if a part of the stone would overlap another existing stone:}
        if tempStone[y - v_py, x - v_px] <> 0 then begin
          if Playground[y, x] <> 0 then b1 := false;
        end;
      end else begin
        {//if, after rotating the stone, a part of it would be out of the
        //playground:
        //if tempStone[y - v_py, x - v_px] <> 0 then b1 := false;
        //try, if the stone is at the right border, to move it some units
        //left, till nothing is out of the playground.}
        if (y < 1) or (y > 23) then {continue;}
        begin
          b1 := false;
        end else
        if tempStone[y - v_py, x - v_px] <> 0 then begin
          if x > 10 then v_px := v_px - 1;
          {//if x < 1 then v_px := v_px + 1; doesn't happen, as stone is align-left}
          goto towardsCenter;
        end;
      end;
    end;
  end;
  {//now insert}
  if b1 then begin
    ThisStone := tempStone;
    px := v_px;
    py := v_py;
    DrawField;
    DrawStone;
    DisplayIt;
  end;
end;


procedure Initialize;
begin
  LoadHighscore;

  for y1 := 1 to 23 do begin
    for x1 := 1 to 10 do begin
      Playground[y1, x1] := 0;
    end;
  end;

  for y1 := 1 to 4 do begin
    for x1 := 1 to 4 do begin
      ThisStone[y1, x1] := 0;
      NextStone[y1, x1] := 2;
    end;
  end;


  MyStones[1,1,1] := 0;
  MyStones[1,1,2] := 1;
  MyStones[1,1,3] := 0;
  MyStones[1,1,4] := 0;
  MyStones[1,2,1] := 1;
  MyStones[1,2,2] := 1;
  MyStones[1,2,3] := 1;
  MyStones[1,2,4] := 0;
  MyStones[1,3,1] := 0;
  MyStones[1,3,2] := 0;
  MyStones[1,3,3] := 0;
  MyStones[1,3,4] := 0;
  MyStones[1,4,1] := 0;
  MyStones[1,4,2] := 0;
  MyStones[1,4,3] := 0;
  MyStones[1,4,4] := 0;

{  (((0,1,0,0),
    (1,1,1,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[2,1,1] := 2;
  MyStones[2,1,2] := 2;
  MyStones[2,1,3] := 2;
  MyStones[2,1,4] := 0;
  MyStones[2,2,1] := 2;
  MyStones[2,2,2] := 0;
  MyStones[2,2,3] := 0;
  MyStones[2,2,4] := 0;
  MyStones[2,3,1] := 0;
  MyStones[2,3,2] := 0;
  MyStones[2,3,3] := 0;
  MyStones[2,3,4] := 0;
  MyStones[2,4,1] := 0;
  MyStones[2,4,2] := 0;
  MyStones[2,4,3] := 0;
  MyStones[2,4,4] := 0;
{   ((2,2,2,0),
    (2,0,0,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[3,1,1] := 3;
  MyStones[3,1,2] := 3;
  MyStones[3,1,3] := 3;
  MyStones[3,1,4] := 0;
  MyStones[3,2,1] := 0;
  MyStones[3,2,2] := 0;
  MyStones[3,2,3] := 3;
  MyStones[3,2,4] := 0;
  MyStones[3,3,1] := 0;
  MyStones[3,3,2] := 0;
  MyStones[3,3,3] := 0;
  MyStones[3,3,4] := 0;
  MyStones[3,4,1] := 0;
  MyStones[3,4,2] := 0;
  MyStones[3,4,3] := 0;
  MyStones[3,4,4] := 0;
{   ((3,3,3,0),
    (0,0,3,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[4,1,1] := 4;
  MyStones[4,1,2] := 4;
  MyStones[4,1,3] := 0;
  MyStones[4,1,4] := 0;
  MyStones[4,2,1] := 0;
  MyStones[4,2,2] := 4;
  MyStones[4,2,3] := 4;
  MyStones[4,2,4] := 0;
  MyStones[4,3,1] := 0;
  MyStones[4,3,2] := 0;
  MyStones[4,3,3] := 0;
  MyStones[4,3,4] := 0;
  MyStones[4,4,1] := 0;
  MyStones[4,4,2] := 0;
  MyStones[4,4,3] := 0;
  MyStones[4,4,4] := 0;
{   ((4,4,0,0),
    (0,4,4,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[5,1,1] := 0;
  MyStones[5,1,2] := 5;
  MyStones[5,1,3] := 5;
  MyStones[5,1,4] := 0;
  MyStones[5,2,1] := 5;
  MyStones[5,2,2] := 5;
  MyStones[5,2,3] := 0;
  MyStones[5,2,4] := 0;
  MyStones[5,3,1] := 0;
  MyStones[5,3,2] := 0;
  MyStones[5,3,3] := 0;
  MyStones[5,3,4] := 0;
  MyStones[5,4,1] := 0;
  MyStones[5,4,2] := 0;
  MyStones[5,4,3] := 0;
  MyStones[5,4,4] := 0;
{   ((0,5,5,0),
    (5,5,0,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[6,1,1] := 6;
  MyStones[6,1,2] := 6;
  MyStones[6,1,3] := 6;
  MyStones[6,1,4] := 6;
  MyStones[6,2,1] := 0;
  MyStones[6,2,2] := 0;
  MyStones[6,2,3] := 0;
  MyStones[6,2,4] := 0;
  MyStones[6,3,1] := 0;
  MyStones[6,3,2] := 0;
  MyStones[6,3,3] := 0;
  MyStones[6,3,4] := 0;
  MyStones[6,4,1] := 0;
  MyStones[6,4,2] := 0;
  MyStones[6,4,3] := 0;
  MyStones[6,4,4] := 0;
{   ((6,6,6,6),
    (0,0,0,0),
    (0,0,0,0),
    (0,0,0,0)),}

  MyStones[7,1,1] := 7;
  MyStones[7,1,2] := 7;
  MyStones[7,1,3] := 0;
  MyStones[7,1,4] := 0;
  MyStones[7,2,1] := 7;
  MyStones[7,2,2] := 7;
  MyStones[7,2,3] := 0;
  MyStones[7,2,4] := 0;
  MyStones[7,3,1] := 0;
  MyStones[7,3,2] := 0;
  MyStones[7,3,3] := 0;
  MyStones[7,3,4] := 0;
  MyStones[7,4,1] := 0;
  MyStones[7,4,2] := 0;
  MyStones[7,4,3] := 0;
  MyStones[7,4,4] := 0;
{   ((7,7,0,0),
    (7,7,0,0),
    (0,0,0,0),
    (0,0,0,0)));}

  LastWinner := 0;
end;


procedure PlayGame;
begin
  clrscr;

  DrawX := 29;
  DrawY := 0;
  px := 4;
  py := 0;
  Randomize;
  ThisStone := MyStones[Trunc(Random * 7) + 1];
  NextStone := MyStones[Trunc(Random * 7) + 1];
  Score := 10;
  DrawField;
  DrawStone;
  ShowNext;

  TimerInterval := 35;
  GameQuit := false;
  GetTime(TimeH1, TimeM1, TimeS1, TimeHu1);
  repeat
   GetTime(TimeH2, TimeM2, TimeS2, TimeHu2);
   if TimeS2 = TimeS1 then begin
     if (TimeHu2-TimeHu1) >= TimerInterval then begin
       StoneMove(0,1);
       TimeH1 := TimeH2;
       TimeM1 := TimeM2;
       TimeS1 := TimeS2;
       TimeHu1 := TimeHu2;
     end;
   end else begin
     if (TimeHu2 + (100 - TimeHu1)) >= TimerInterval then begin
       StoneMove(0,1);
       TimeH1 := TimeH2;
       TimeM1 := TimeM2;
       TimeS1 := TimeS2;
       TimeHu1 := TimeHu2;
     end;
   end;
   if (keypressed) and (not (GameQuit)) then begin
    Ch := ReadKey;
    if Ch = #0 then
      begin
      Ch := ReadKey;
      {WriteLn('You hit special key number ',
          Ord(Ch));}
      {GameQuit := true;}
      Case Ord(Ch) of
        {Left}
        75: StoneMove(-1,0);
        {right}
        77: StoneMove(1,0);
        {up}
        72: StoneRotate;
        {down}
        80: begin
          repeat
            Score := Score + 5;
            StoneMove(0, 1);
          until (py = 0) or (GameQuit);
        end;
      end;
    end else begin
      {WriteLn('You hit a key with ASCII ',
          'code ',Ord(Ch));}
      Case Ord(Ch) of
        {Esc:}
        27: GameQuit := true;
      end;
    end;
   end;
  until GameQuit;
  AddHighscore;
  SaveHighscore;

  {clear playground:}
  for y := 1 to 23 do begin
    for x := 1 to 10 do begin
      Playground[y, x] := 0;
    end;
  end;
  Score := 0;

end;


procedure StartScreen;
begin
  clrscr;
  GameQuit := false;
  GotoXY(1,1);
  Write('Ŀ McTris v0.8 ');
  GotoXY(1,2);
  Write('       ');
  GotoXY(9,4);
  Write('"The somewhat different Tetris."');
  GotoXY(9,5);
  Write('-Written by Manuel Haim in 2004-');
  TextColor(9);
  GotoXY(7,21);
  Write('-Open Source Release, free to copy-');
  GotoXY(10,22);
  Write('[http://McSquirrel.istcool.de]');
  TextColor(7);

  GotoXY(50,2);
  Write('');
  GotoXY(50,3);
  Write('');
  GotoXY(55,2);
  Write('Highscores:');
  for z01 := 1 to 20 do begin
    GotoXY(50,3+z01);
    Write('');
    if LastWinner = z01 then TextColor(10+Blink);
    GotoXY(53,3+z01);
    Write(Highscore[z01].Name);
    GotoXY(65,3+z01);
    Write(Highscore[z01].Score:10);
    TextColor(7);
  end;

  GotoXY(1,24);
  Write('   Ŀ   ');
  GotoXY(1,25);
  Write(' Press Return to play game, Esc to exit. ');
  repeat until keypressed;
  ch1 := readkey;
  while not ((not(ch1 = #0)) and ((ord(ch1) = 13) or (ord(ch1) = 27))) do begin
    ch1 := readkey;
  end;
  Case Ord(ch1) of
    {Return:}
    13: Begin PlayGame; GameQuit := false; end;
    {Esc:}
    27: GameQuit := true;
  end;
end;




begin
  Initialize;
  repeat StartScreen; until GameQuit = true;
  clrscr;
  TextColor(7);
  writeln('Thank you for playing McTris');
end.