/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.lang.reflect.Array;
import java.util.Vector;

public class Sprite {
    private static Vector v_animations = new Vector();
    private static Image bg;
    private static Toolkit toolkit;
    private static ImageObserver observer;
    private Image currentImage;
    protected int oldx = 0;
    protected int oldy = 0;
    protected int width;
    protected int height;
    protected int phases = 0;
    protected int pict;
    protected int animationId = 0;
    public int x = 0;
    public int y = 0;
    public static int bgOffsetX;
    public int counter1 = 0;
    public int counter2 = 0;
    public byte countdown = (byte)5;
    public int typ = 2;

    public Sprite(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.animationId = n3;
        this.pict = n4;
        this.phases = Array.getLength(v_animations.elementAt(n3)) / 2;
        this.currentImage = this.getImage(n4);
        this.saveoldPos();
        this.setWidthHeight();
    }

    public static void setToolkit(Toolkit toolkit) {
        Sprite.toolkit = toolkit;
    }

    public static void addAnimation(Image image, int n) {
        Image[] imageArray = new Image[n << 1];
        int n2 = image.getWidth(observer) << 1;
        int n3 = image.getHeight(observer) << 1;
        image = image.getScaledInstance(n2, n3, 2);
        int n4 = 0;
        while (n4 < n) {
            int[] nArray = new int[n2 * n3 / n];
            int[] nArray2 = new int[n2 * n3 / n];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, n4 * n3 / n, n2, n3 / n, nArray, 0, n2);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3 / n, nArray, 0, n2);
            imageArray[n4] = toolkit.createImage(memoryImageSource);
            int n5 = n3 / n;
            int n6 = 0;
            while (n6 < n5) {
                int n7 = 0;
                while (n7 < n2) {
                    int n8 = n6 * n2;
                    nArray2[n8 + n7] = nArray[n8 + (n2 - n7 - 1)];
                    ++n7;
                }
                ++n6;
            }
            memoryImageSource = new MemoryImageSource(n2, n3 / n, nArray2, 0, n2);
            imageArray[n4 + n] = toolkit.createImage(memoryImageSource);
            ++n4;
        }
        v_animations.addElement(imageArray);
    }

    public static void setBgImage(Image image) {
        bg = image;
    }

    public static void setImageObserver(ImageObserver imageObserver) {
        observer = imageObserver;
    }

    public static Image getImage(int n, int n2) {
        Image image = (Image)Array.get(v_animations.elementAt(n), n2);
        return image.getScaledInstance(image.getWidth(observer) / 2, image.getHeight(observer) / 2, 2);
    }

    public Image getImage(int n) {
        return (Image)Array.get(v_animations.elementAt(this.animationId), n);
    }

    public void mirror() {
        this.pict = (this.pict + this.phases) % (this.phases << 1);
        this.currentImage = (Image)Array.get(v_animations.elementAt(this.animationId), this.pict);
        this.setWidthHeight();
    }

    public void setAnimationId(int n, Graphics graphics) {
        this.restoreBg(graphics);
        this.animationId = n;
        this.pict = 0;
        this.phases = Array.getLength(v_animations.elementAt(n)) / 2;
        this.saveoldPos();
        int n2 = this.width;
        int n3 = this.height;
        this.setWidthHeight();
        this.x += n2 - this.width >> 1;
        this.y += n3 - this.height >> 1;
        int n4 = this.getOrientation();
        this.currentImage = this.getImage(0);
        if (n4 != this.getOrientation()) {
            this.mirror();
        }
    }

    public void setWidthHeight() {
        this.width = ((Image)Array.get(v_animations.elementAt(this.animationId), this.pict)).getWidth(observer);
        this.height = ((Image)Array.get(v_animations.elementAt(this.animationId), this.pict)).getHeight(observer);
    }

    public void nextPict(boolean bl) {
        if (this.getOrientation() == 1) {
            ++this.pict;
            if (this.pict >= this.phases) {
                this.pict = this.phases - 1;
                if (bl) {
                    this.pict = 0;
                }
            }
        } else {
            ++this.pict;
            if (this.pict >= this.phases << 1) {
                this.pict = (this.phases << 1) - 1;
                if (bl) {
                    this.pict = this.phases;
                }
            }
        }
        this.currentImage = (Image)Array.get(v_animations.elementAt(this.animationId), this.pict);
    }

    public int getOrientation() {
        if (this.pict < this.phases) {
            return 1;
        }
        return -1;
    }

    public void saveoldPos() {
        this.oldx = this.x;
        this.oldy = this.y;
    }

    public void drawImage(Graphics graphics) {
        graphics.drawImage(this.currentImage, this.x - bgOffsetX, this.y, observer);
    }

    public void restoreBg(Graphics graphics) {
        graphics.drawImage(bg, this.oldx - bgOffsetX, Math.max(this.oldy, 0), this.oldx + this.width - bgOffsetX, Math.min(this.oldy + this.height, 320), this.oldx, Math.max(this.oldy, 0), this.oldx + this.width, Math.min(this.oldy + this.height, 320), observer);
    }

    public boolean collide(int n, int n2) {
        return n <= this.x + this.width && n >= this.x && n2 <= this.y + this.height && n2 >= this.y;
    }

    static {
        bgOffsetX = 0;
    }
}

