/**Klasse zum Erstellen von Aufgaben 
 * 
 * @author  Hinnerk Sebe 
 * @version 25.01.07
 */
public class Aufgabe {

 // --------- Felder ---------------------------------
/**Feld fr den Namen einer Aufgabe*/ 
 private String name;

/**Feld fr die Beschreibung einer Aufgabe*/  
 private String beschreibung;

/**Feld fr die Prioritt einer Aufgabe*/  
 private int prioritt;

/**Feld fr den Aufwand in Tagen zum Erledigen einer Aufgabe*/  
 private int aufwand;

/**Feld fr deas Datum, an dem die Aufgabe erledigt sein muss*/  
 private int datum;
    

    
 // --------- Konstruktor(en) ------------------------

    /** Konstruktor, der eine Aufgabe erstellt und alle Parameter initialisiert
     * @param name
     * @param beschreibung
     * @param prioritt
     * @param aufwand
     * @param datum
     */   
        Aufgabe(String name, String beschreibung, int prioritt, int aufwand, int datum)
        {
        this.name = name;
        this.beschreibung = beschreibung;
        setPrioritt (prioritt);
        this.aufwand = aufwand;
        this.datum = datum;
        }


 // --------- Methoden -------------------------------
/**Methode zum Setzen eines Aufgabennamens
 * @param name ist der Name einer Aufgabe
 */ 
 public void setName(String name){
 this.name = name;
 }

/**Methode zum Setzen einer Aufgabenbeschreibung
 * @param beschreibung ist die Beschreibung einer Aufgabe
 */  
 public void setBeschreibung(String beschreibung){
 this.beschreibung = beschreibung;
 }

/**Methode zum Setzen der Prioritt einer Aufgabe 
 * @param prioritt ist die Prioritt einer Aufgabe, die zwischen 1 und 10 liegen muss
 */ 
 public void setPrioritt(int prioritt){
 if (prioritt>=1&&prioritt<=10){
      this.prioritt = prioritt;}
      else if (prioritt<1){setPrioritt (1);}  //Falls die Eingabe ungltig ist, wird der Wert auf 1
      else {setPrioritt(10);}                  //oder 10 je nach Nherung gesetzt
 }
 
/**Methode zum Setzen des Aufwandes zum Erledigen einer Aufgabe
 * @param aufwand ist der Aufwand zum Erledigen einer Aufgabe in Tagen
 */  
 public void setAufwand(int aufwand){
 this.aufwand = aufwand;
 }

/**Methode zum Setzen des Datums, an dem die Aufgabe erledigt sein muss
 * @param datum ist der Tag im Jahr, an dem die Aufgabe erledigt sein muss
 */  
 public void setDatum(int datum){
 this.datum = datum;
 }

/**Methode zum Erfragen des Aufgabennamens*/ 
 public String getName(){
 return name;
 }

/**Methode zum Erfragen der Aufgabenbeschreibung*/  
 public String getBeschreibung(){
 return beschreibung;
 }

/**Methode zum Erfragen der Prioritt einer Aufgabe*/  
 public int getPrioritt(){
 return prioritt;
 }
    
/**Methode zum Erfragen des Aufwandes fr eine Aufgabe*/ 
 public int getAufwand(){
 return aufwand;
 }

/**Methode zum Erfragen des Datums, an dem die Aufgabe erledigt sein muss*/ 
 public int getDatum(){
 return datum;
 }
    
/**Methode, um die Prioritt zweier Aufgaben zu vergleichen*/
public boolean istDringenderAls (Aufgabe zweiteAufgabe){
 if ((getDatum()-getAufwand()) < (zweiteAufgabe.getDatum()-zweiteAufgabe.getAufwand()))
 return true;
 else if ((getDatum()-getAufwand()) > (zweiteAufgabe.getDatum()-zweiteAufgabe.getAufwand()))
 return false;
 else {
        if (getPrioritt() < zweiteAufgabe.getPrioritt())
            return false;
        else if (getPrioritt() > zweiteAufgabe.getPrioritt())
            return true;
        else return true;    
    }
 }

/**toString- Methode, um eine Aufgabe als String auszugeben*/ 
 public String toString(){
 return
 "Aufgabe         : "+name+
 "\nBeschreibung    : "+beschreibung+ 
 "\nPrioritt       : "+prioritt+
 "\nAufwand         : "+aufwand+
 "\nZu erledigen bis: Tag "+datum+" des Jahres\n"; 
 }
 
/**Methode, um die gesamte Aufgabe auf Konsole auszugeben*/ 
 public void druckeAufgabe(){
 System.out.println(toString());
 }


}// Ende der Klasse Aufgabe
