/** Klasse zum Verwalten von Aufgaben
 * 
 * @author  Hinnerk Sebe
 * @version 25.01.07
 */
public class Aufgabenverwaltung {
 // --------- Felder ---------------------------------
/** Feld fr Objekte der Klasse Liste, bzw ihrer Unterklasen */   
 private static Liste aufgaben = new Nil();

	
 // --------- Konstruktor(en) ------------------------

    /** Default Konstruktor **/   
        Aufgabenverwaltung(){}


 // --------- Methoden -------------------------------
/** Methode, um die nchste zu erledigende Aufgabe zu erfragen */
public static Aufgabe liefereNaechsteAufgabe() {
   if(aufgaben.istLeer()) {
   return null;
   }
   else return ((Cons)aufgaben).getInhalt();
   }

/** Methode, um die nchste zu erledigende Aufgabe aus der Liste zu entfernen */
public static void bearbeiteNaechsteAufgabe() {
   if(aufgaben.istLeer()){}
   else
   aufgaben = ((Cons)aufgaben).getRest();
    }
   
/** Methode, um eine neue Aufgabe in die Liste einzufgen
 * @param neueAufgabe ist ein neues Objekt der Klasse Aufgabe
 */ 
    public static void aufgabeEinsortieren(Aufgabe neueAufgabe) {
    if(aufgaben.istLeer()) 
    {
    aufgaben = new Cons(neueAufgabe);
    } 
        else {
        Cons meinZeiger = (Cons)aufgaben;
        if(neueAufgabe.istDringenderAls(meinZeiger.getInhalt())) {
        aufgaben = new Cons(neueAufgabe, meinZeiger);
        } 
           else {
                while(!meinZeiger.getRest().istLeer()) {
                    Cons nchste = (Cons)meinZeiger.getRest();
                    if(neueAufgabe.istDringenderAls(nchste.getInhalt())) {
                    break;
                    }
                    meinZeiger = nchste;
                }
                meinZeiger.setRest(new Cons(neueAufgabe, meinZeiger.getRest()));
            }
        }
    }
   
/**Methode, um alle Aufgaben aus der Liste auf Konsole auszugeben*/
    public static void druckeAufgabenliste (){
        if (aufgaben.istLeer()) {
			System.out.println("Es sind keine Aufgaben in der Liste vorhanden");
		} 
		else {
			Liste meinZeiger = (Cons) aufgaben;
			while (!meinZeiger.istLeer()) {
				Aufgabe aufgabe = ((Cons)meinZeiger).getInhalt();
				System.out.println(aufgabe);
				meinZeiger = ((Cons)meinZeiger).getRest();
			}
		}
    }
	


}// Ende der Klasse Afgabenverwaltung
